/**************************************************************************
 * (C) 2019-2021 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.services.impl.messaging.message;

import java.util.Map;

import com.sap.cds.services.EventContext;
import com.sap.cds.services.EventName;

/**
 * Describes the content of a String-based structured message, received via the messaging adapter
 */
@EventName(ChangedEventContext.EVENT_CHANGED)
public interface ChangedEventContext extends EventContext {

	public static final String EVENT_CHANGED = "CHANGED";

	static ChangedEventContext create(String entityName) {
		return EventContext.create(EVENT_CHANGED, entityName).as(ChangedEventContext.class);
	}

	Map<String, Object> getData();

	void setData(Map<String, Object> data);

}
