/**************************************************************************
 * (C) 2019-2021 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.services.impl.mt;

import java.util.Arrays;

import com.sap.cds.services.handler.EventHandler;
import com.sap.cds.services.handler.annotations.HandlerOrder;
import com.sap.cds.services.handler.annotations.On;
import com.sap.cds.services.handler.annotations.ServiceName;
import com.sap.cds.services.mt.ReadTenantsEventContext;
import com.sap.cds.services.mt.TenantInfo;
import com.sap.cds.services.mt.TenantProviderService;
import com.sap.cds.services.utils.OrderConstants;

@ServiceName(value = TenantProviderService.DEFAULT_NAME, type = TenantProviderService.class)
public class TenantProviderDefaultOnHandler implements EventHandler {

	@On
	@HandlerOrder(OrderConstants.On.DEFAULT_ON)
	protected void defaultReadTenants(ReadTenantsEventContext context) {
		TenantInfo providerTenantInfo = TenantInfo.create();
		providerTenantInfo.setTenant(null); // null is the indicator for provider tenant
		context.setResult(Arrays.asList(providerTenantInfo));
	}

}
