/**************************************************************************
 * (C) 2019-2021 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.services.impl.outbox;

import com.sap.cds.services.EventContext;
import com.sap.cds.services.Service;
import com.sap.cds.services.ServiceDelegator;
import com.sap.cds.services.messaging.MessagingService;
import com.sap.cds.services.outbox.OutboxEnrollEventContext;
import com.sap.cds.services.outbox.OutboxService;

/**
 * Implementation of the {@link MessagingService} interface.
 */
public class OutboxServiceImpl extends ServiceDelegator implements OutboxService {

	public OutboxServiceImpl(String name) {
		super(name);
	}

	@Override
	public void enroll(Service service, EventContext context) {
		OutboxEnrollEventContext outboxContext = OutboxEnrollEventContext.create();

		outboxContext.setOutboxedService(service);
		outboxContext.setOutboxedContext(context);

		emit(outboxContext);
	}
}
