/**************************************************************************
 * (C) 2019-2021 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.services.impl.persistence;

import com.sap.cds.services.application.ApplicationLifecycleService;
import com.sap.cds.services.application.ApplicationPreparedEventContext;
import com.sap.cds.services.environment.CdsProperties.DataSource;
import com.sap.cds.services.handler.EventHandler;
import com.sap.cds.services.handler.annotations.Before;
import com.sap.cds.services.handler.annotations.ServiceName;
import com.sap.cds.services.impl.utils.CdsServiceUtils;
import com.sap.cds.services.persistence.PersistenceService;

@ServiceName(ApplicationLifecycleService.DEFAULT_NAME)
public class CsvInitializationHandler implements EventHandler {

	@Before
	public void initalizeDatabase(ApplicationPreparedEventContext context) {
		DataSource config = context.getCdsRuntime().getEnvironment().getCdsProperties().getDataSource();
		String csvInitMode = config.getCsvInitializationMode();
		if("always".equals(csvInitMode) || ("embedded".equals(csvInitMode) && config.isEmbedded())) {
			PersistenceService db = CdsServiceUtils.getDefaultPersistenceService(context);
			if(db != null) {
				new CsvDataLoader(db, context.getCdsRuntime()).load();
			}
		}
	}

}
