/**************************************************************************
 * (C) 2019-2021 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.services.impl.persistence;

import java.util.HashMap;
import java.util.List;

import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.services.EventContext;
import com.sap.cds.services.Service;
import com.sap.cds.services.cds.CqnService;
import com.sap.cds.services.handler.EventHandler;
import com.sap.cds.services.handler.annotations.After;
import com.sap.cds.services.handler.annotations.ServiceName;
import com.sap.cds.services.impl.messaging.message.ChangedEventContext;
import com.sap.cds.services.persistence.PersistenceService;
import com.sap.cds.services.utils.model.CdsAnnotations;

@ServiceName(value = "*", type = PersistenceService.class)
public class MessagingHandler implements EventHandler {

	@After(event = {CqnService.EVENT_CREATE, CqnService.EVENT_UPDATE, CqnService.EVENT_DELETE, CqnService.EVENT_UPSERT})
	public void afterCreate(EventContext context) {
		if (context.getTarget() != null) {

			String entity = context.getTarget().getQualifiedName();
			String event = context.getEvent();

			Service service = context.getServiceCatalog().getService(context.getTarget().getQualifier());
			if (service != null && isEmmittable(context.getTarget(), event)) {
				ChangedEventContext changedContext = ChangedEventContext.create(entity);
				changedContext.setData(new HashMap<>()); // no data for now
				service.emit(changedContext);
			}
		}
	}

	private boolean isEmmittable(CdsEntity entity, String event) {
		Object emit = CdsAnnotations.MESSAGING_EMIT.getOrDefault(entity);
		if (emit != null) {
			if (emit instanceof Boolean) {
				if ((Boolean) emit) {
					return true;
				}
			} else if (emit instanceof List) {
				List<?> events = (List<?>) emit;
				return events.stream().map(e -> e.toString()).anyMatch(e -> e.equals(event));
			}
		}
		return false;
	}
}
