/**************************************************************************
 * (C) 2019-2021 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.services.impl.runtime.mockusers;

import com.sap.cds.services.authentication.AuthenticationInfo;
import com.sap.cds.services.authentication.BasicAuthenticationInfo;
import com.sap.cds.services.request.UserInfo;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.runtime.UserInfoProvider;

/**
 * The {@link MockedUserInfoProvider} interprets an {@link AuthenticationInfo} as the user name of a mocked user.
 * Mock users need to be configured.
 */
public class MockedUserInfoProvider implements UserInfoProvider {

	private final CdsRuntime runtime;

	public MockedUserInfoProvider(CdsRuntime runtime) {
		this.runtime = runtime;
	}

	@Override
	public UserInfo get() {
		AuthenticationInfo authenticationInfo = runtime.getProvidedAuthenticationInfo();
		if (authenticationInfo instanceof BasicAuthenticationInfo) {
			BasicAuthenticationInfo basic = (BasicAuthenticationInfo) authenticationInfo;
			return runtime.getEnvironment().getCdsProperties().getSecurity().getMock().getUsers()
				.stream()
				.filter(user -> user.getName().equals(basic.getUsername()))
				.findFirst()
				.map(user -> new MockedUserInfo(user))
				.orElse(null);
		} else {
			return null;
		}
	}

}
