/**************************************************************************
 * (C) 2019-2021 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.services.impl.utils;

import java.util.List;

import com.sap.cds.ql.StructuredTypeRef;
import com.sap.cds.ql.cqn.CqnLimit;
import com.sap.cds.ql.cqn.CqnModifier;
import com.sap.cds.ql.cqn.CqnSelectListItem;
import com.sap.cds.ql.cqn.CqnSortSpecification;
import com.sap.cds.ql.impl.ExpressionVisitor;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.services.utils.model.CdsModelUtils;

public abstract class TargetAwareCqnModifier implements CqnModifier {

	private final CdsEntity target;

	public TargetAwareCqnModifier(CdsEntity target) {
		this.target = target;
	}

	protected abstract TargetAwareCqnModifier create(CdsEntity target);

	@Override
	public CqnSelectListItem expand(StructuredTypeRef ref, List<CqnSelectListItem> items, List<CqnSortSpecification> orderBy, CqnLimit limit) {
		CdsEntity refTarget = getRefTarget(ref);
		if(refTarget != null) {
			CqnModifier modifier = create(refTarget);
			// copy selection deep
			items = ExpressionVisitor.copy(items, modifier);
		}

		return CqnModifier.super.expand(ref, items, orderBy, limit);
	}

	protected CdsEntity getTarget() {
		return target;
	}

	protected CdsEntity getRefTarget(StructuredTypeRef ref) {
		return CdsModelUtils.getRefTarget(ref, target);
	}

}