/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.authorization;

import com.sap.cds.Result;
import com.sap.cds.impl.builder.model.Conjunction;
import com.sap.cds.ql.CQL;
import com.sap.cds.ql.Select;
import com.sap.cds.ql.cqn.AnalysisResult;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.cqn.CqnReference;
import com.sap.cds.ql.cqn.CqnSelect;
import com.sap.cds.ql.cqn.CqnStatement;
import com.sap.cds.ql.cqn.CqnStructuredTypeRef;
import com.sap.cds.ql.cqn.ResolvedSegment;
import com.sap.cds.reflect.CdsAnnotatable;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.EventContext;
import com.sap.cds.services.authorization.EntityAccessEventContext;
import com.sap.cds.services.impl.draft.ParentEntityLookup;
import com.sap.cds.services.impl.utils.CdsModelUtils;
import com.sap.cds.services.impl.utils.CdsServiceUtils;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.DraftUtils;
import com.sap.cds.services.utils.ErrorStatusException;
import com.sap.cds.services.utils.model.CdsAnnotations;
import com.sap.cds.services.utils.model.Restriction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;

class AuthorizationEntity {
    private final EntityAccessEventContext context;
    private final BiFunction<CdsModel, String, Restriction> restrictionLookup;
    private final Function<CdsEntity, List<ParentEntityLookup.ParentEntityLookupResult>> parentEntityLookup;
    private CdsEntity authorizationEntity;
    private CqnStructuredTypeRef authorizationPath;
    private boolean isDraft;

    public static AuthorizationEntity resolve(EntityAccessEventContext context, BiFunction<CdsModel, String, Restriction> restrictionLookup, Function<CdsEntity, List<ParentEntityLookup.ParentEntityLookupResult>> parentEntityLookup) {
        return new AuthorizationEntity(context, restrictionLookup, parentEntityLookup);
    }

    public CdsEntity getAuthorizationEntity() {
        return this.authorizationEntity;
    }

    public CqnStructuredTypeRef getAuthorizationPath() {
        return this.authorizationPath;
    }

    public boolean isDraft() {
        return this.isDraft;
    }

    public CqnPredicate authorizationCondition(CdsEntity authorizationEntity, String event) {
        if (this.context.getCdsRuntime().getEnvironment().getCdsProperties().getSecurity().getInstanceBasedAuthorization().isEnabled().booleanValue() && (event.equals("READ") || event.equals("DELETE") || event.equals("UPDATE") || event.equals("draftEdit") || event.equals("draftActivate"))) {
            return this.context.getService().calcWhereCondition(authorizationEntity.getQualifiedName(), event);
        }
        return null;
    }

    private AuthorizationEntity(EntityAccessEventContext context, BiFunction<CdsModel, String, Restriction> restrictionLookup, Function<CdsEntity, List<ParentEntityLookup.ParentEntityLookupResult>> parentEntityLookup) {
        this.context = context;
        this.restrictionLookup = restrictionLookup;
        this.parentEntityLookup = parentEntityLookup;
        if (context.getAccessQuery() != null && context.getCdsRuntime().getEnvironment().getCdsProperties().getSecurity().getAuthorizeAutoExposedEntities().isEnabled().booleanValue()) {
            this.findAuthorizationEntity(context.getAccessQuery());
        } else {
            this.authorizationEntity = context.getTarget();
        }
    }

    private void findAuthorizationEntity(CqnStatement query) {
        ArrayList<CqnReference.Segment> tmpAuthorizationPath = new ArrayList<CqnReference.Segment>();
        AnalysisResult pathAnalysis = CdsModelUtils.getEntityPath(query, this.context.getModel());
        Iterator segsRevIter = pathAnalysis.reverse();
        while (segsRevIter.hasNext()) {
            ResolvedSegment segment = (ResolvedSegment)segsRevIter.next();
            if (this.authorizationEntity == null && this.isAuthorizationEntity(segment.entity())) {
                this.authorizationEntity = segment.entity();
            }
            if (this.authorizationEntity != null) {
                tmpAuthorizationPath.add(0, segment.segment());
            }
            if (this.isDraft || !DraftUtils.isDraftEnabled((CdsEntity)segment.entity()) || segment.keys() == null) continue;
            Boolean isActiveEntity = (Boolean)segment.keys().get("IsActiveEntity");
            this.isDraft = Boolean.FALSE.equals(isActiveEntity);
        }
        assert (this.authorizationEntity == null || !tmpAuthorizationPath.isEmpty());
        if (this.authorizationEntity != null) {
            this.authorizationPath = CQL.to(tmpAuthorizationPath).asRef();
        } else if (DraftUtils.isDraftEnabled((CdsEntity)pathAnalysis.targetEntity())) {
            if (this.isDraft) {
                this.authorizationEntity = pathAnalysis.targetEntity();
            } else {
                this.findAuthorizationEntity(pathAnalysis.targetEntity(), pathAnalysis.targetKeys());
            }
        }
    }

    private boolean isAuthorizationEntity(CdsEntity entity) {
        boolean isTextTable = entity.getQualifiedName().endsWith("_texts") || entity.getQualifiedName().endsWith(".texts");
        boolean autoexposed = (Boolean)CdsAnnotations.AUTOEXPOSED.getOrDefault((CdsAnnotatable)entity);
        if (!autoexposed && !isTextTable) {
            return true;
        }
        boolean autoexpose = (Boolean)CdsAnnotations.AUTOEXPOSE.getOrDefault((CdsAnnotatable)entity);
        if (autoexposed && autoexpose && !isTextTable) {
            return true;
        }
        Restriction restriction = this.restrictionLookup.apply(this.context.getModel(), entity.getQualifiedName());
        return restriction != null;
    }

    private void findAuthorizationEntity(CdsEntity targetEntity, Map<String, Object> targetKeys) {
        Restriction restriction;
        CdsEntity testEntity = targetEntity;
        while (this.authorizationEntity == null) {
            List<ParentEntityLookup.ParentEntityLookupResult> parentsLookup = this.parentEntityLookup.apply(testEntity);
            if (parentsLookup == null || parentsLookup.isEmpty()) {
                throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.NO_PARENT_ENTITY, new Object[]{testEntity.getQualifiedName()});
            }
            if (parentsLookup.size() > 1) break;
            CdsEntity entity = parentsLookup.get(0).getParentEntity();
            if (this.isAuthorizationEntity(entity)) {
                this.authorizationEntity = entity;
                continue;
            }
            testEntity = entity;
        }
        if (this.authorizationEntity != null && (restriction = this.restrictionLookup.apply(this.context.getModel(), this.authorizationEntity.getQualifiedName())) != null && this.authorizationCondition(this.authorizationEntity, this.context.getAccessEventName()) != null) {
            this.authorizationEntity = null;
        }
        if (this.authorizationEntity == null) {
            if (targetKeys == null || targetKeys.isEmpty()) {
                return;
            }
            CdsEntity pathEntity = targetEntity;
            Map<String, Object> pathEntityKeys = targetKeys;
            while (this.authorizationEntity == null) {
                List<ParentEntityLookup.ParentEntityLookupResult> parentsLookup = this.parentEntityLookup.apply(pathEntity);
                if (parentsLookup == null || parentsLookup.isEmpty()) {
                    throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.PARENT_NOT_EXISTING, new Object[]{pathEntity.getQualifiedName()});
                }
                int numberParents = 0;
                CdsEntity parentPathEntity = null;
                Map<String, Object> parentPathEntityKeys = null;
                for (ParentEntityLookup.ParentEntityLookupResult parentLookup : parentsLookup) {
                    String compositionName = parentLookup.getComposition().getName();
                    CqnPredicate pred = (CqnPredicate)pathEntityKeys.entrySet().stream().map(key -> CQL.to((String)compositionName).get((String)key.getKey()).eq(key.getValue())).collect(Conjunction.and());
                    Select select = Select.from((CdsEntity)parentLookup.getParentEntity()).where(pred);
                    Result result = CdsServiceUtils.getDefaultPersistenceService((EventContext)this.context).run((CqnSelect)select, new Object[0]);
                    if (!result.first().isPresent()) continue;
                    parentPathEntity = parentLookup.getParentEntity();
                    parentPathEntityKeys = AuthorizationEntity.extractKeys((Map)result.first().get(), parentLookup.getParentEntity());
                    numberParents = (int)((long)numberParents + result.rowCount());
                }
                if (parentPathEntity == null) {
                    throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.PARENT_NOT_EXISTING, new Object[]{pathEntity.getQualifiedName()});
                }
                if (numberParents > 1) {
                    throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.MULTIPLE_PARENTS, new Object[]{numberParents, pathEntity.getQualifiedName()});
                }
                if (this.isAuthorizationEntity(parentPathEntity)) {
                    this.authorizationEntity = parentPathEntity;
                    this.authorizationPath = CQL.entity((String)this.authorizationEntity.getQualifiedName()).filter((CqnPredicate)CQL.matching(parentPathEntityKeys)).asRef();
                    continue;
                }
                pathEntity = parentPathEntity;
                pathEntityKeys = parentPathEntityKeys;
            }
        }
    }

    private static Map<String, Object> extractKeys(Map<String, Object> m, CdsEntity entity) {
        HashMap<String, Object> result = new HashMap<String, Object>(m);
        result.entrySet().removeIf(entry -> entity.findElement((String)entry.getKey()).map(e -> e.isKey()).orElse(false) == false && !"IsActiveEntity".equals(entry.getKey()));
        if ((long)result.size() != entity.keyElements().count()) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.NO_KEYS_IN_RESULT, new Object[]{entity});
        }
        return result;
    }
}

