/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.cds;

import com.sap.cds.CdsDataProcessor;
import com.sap.cds.ql.CdsDataException;
import com.sap.cds.ql.cqn.Path;
import com.sap.cds.reflect.CdsAnnotatable;
import com.sap.cds.reflect.CdsBaseType;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.reflect.CdsSimpleType;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.reflect.CdsType;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.EventContext;
import com.sap.cds.services.cds.ApplicationService;
import com.sap.cds.services.handler.EventHandler;
import com.sap.cds.services.handler.annotations.Before;
import com.sap.cds.services.handler.annotations.HandlerOrder;
import com.sap.cds.services.handler.annotations.ServiceName;
import com.sap.cds.services.impl.utils.CdsServiceUtils;
import com.sap.cds.services.impl.utils.ValidatorUtils;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import com.sap.cds.services.utils.model.CdsAnnotations;
import com.sap.cds.util.CdsTypeUtils;
import java.util.List;
import java.util.stream.Collectors;

@ServiceName(value={"*"}, type={ApplicationService.class})
public class RangeAssertionHandler
implements EventHandler {
    @Before(event={"CREATE", "UPDATE", "UPSERT"})
    @HandlerOrder(value=11100)
    public void runCheck(EventContext context) {
        CdsDataProcessor.create().addValidator(RangeAssertionHandler::hasAssertRange, this.rangeValidator(context)).process(CdsServiceUtils.getEntities(context), (CdsStructuredType)context.getTarget());
    }

    private CdsDataProcessor.Validator rangeValidator(EventContext context) {
        return (path, element, value) -> {
            List rangeValues;
            List<Comparable<Object>> rangeConvertedValues;
            if (value != null && !(rangeConvertedValues = RangeAssertionHandler.getConvertedRange(context, rangeValues = CdsAnnotations.ASSERT_RANGE.getListOrValue((CdsAnnotatable)element, null), element, element.getDeclaringType().getName())).isEmpty()) {
                Comparable<Object> minValue = rangeConvertedValues.get(0);
                Comparable elementValue = (Comparable)value;
                Comparable<Object> maxValue = rangeConvertedValues.get(1);
                if (elementValue.compareTo(maxValue) > 0 || elementValue.compareTo(minValue) < 0) {
                    ValidatorUtils.handleValidationError(context, path, element, CdsErrorStatuses.VALUE_OUT_OF_RANGE, null, element.getName(), minValue, maxValue);
                }
            }
        };
    }

    private static boolean hasAssertRange(Path path, CdsElement element, CdsType type) {
        List rangeValues = CdsAnnotations.ASSERT_RANGE.getListOrValue((CdsAnnotatable)element, null);
        return rangeValues instanceof List && rangeValues.size() == 2 && RangeAssertionHandler.isAllowedType(element.getType());
    }

    private static List<Comparable<Object>> getConvertedRange(EventContext context, List<Object> rangeValues, CdsElement element, String entityName) {
        try {
            return rangeValues.stream().map(oValue -> (Comparable)CdsTypeUtils.parse((CdsBaseType)((CdsSimpleType)element.getType().as(CdsSimpleType.class)).getType(), (String)oValue.toString())).collect(Collectors.toList());
        }
        catch (CdsDataException e) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.INVALID_ANNOTATION, new Object[]{CdsAnnotations.ASSERT_RANGE.toString(), element.getName(), entityName, e});
        }
    }

    private static boolean isAllowedType(CdsType elementType) {
        if (!(elementType instanceof CdsSimpleType)) {
            return false;
        }
        switch (((CdsSimpleType)elementType.as(CdsSimpleType.class)).getType()) {
            case INTEGER: 
            case INTEGER64: 
            case DECIMAL: 
            case DECIMAL_FLOAT: 
            case DOUBLE: 
            case DATE: 
            case TIME: 
            case DATETIME: 
            case TIMESTAMP: {
                return true;
            }
        }
        return false;
    }
}

