/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.draft;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.sap.cds.CdsDataProcessor;
import com.sap.cds.Result;
import com.sap.cds.ResultBuilder;
import com.sap.cds.Row;
import com.sap.cds.Struct;
import com.sap.cds.ql.CQL;
import com.sap.cds.ql.Delete;
import com.sap.cds.ql.Insert;
import com.sap.cds.ql.Predicate;
import com.sap.cds.ql.RefSegment;
import com.sap.cds.ql.Select;
import com.sap.cds.ql.StructuredType;
import com.sap.cds.ql.StructuredTypeRef;
import com.sap.cds.ql.Update;
import com.sap.cds.ql.Value;
import com.sap.cds.ql.cqn.AnalysisResult;
import com.sap.cds.ql.cqn.CqnDelete;
import com.sap.cds.ql.cqn.CqnInsert;
import com.sap.cds.ql.cqn.CqnModifier;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.cqn.CqnSelect;
import com.sap.cds.ql.cqn.CqnSelectListItem;
import com.sap.cds.ql.cqn.CqnSelectListValue;
import com.sap.cds.ql.cqn.CqnSortSpecification;
import com.sap.cds.ql.cqn.CqnStatement;
import com.sap.cds.ql.cqn.CqnStructuredTypeRef;
import com.sap.cds.ql.cqn.CqnUpdate;
import com.sap.cds.ql.cqn.CqnValue;
import com.sap.cds.ql.cqn.Modifier;
import com.sap.cds.ql.cqn.ResolvedSegment;
import com.sap.cds.ql.impl.ExpressionVisitor;
import com.sap.cds.ql.impl.SelectBuilder;
import com.sap.cds.ql.impl.SelectListValueBuilder;
import com.sap.cds.reflect.CdsAnnotatable;
import com.sap.cds.reflect.CdsAssociationType;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.EventContext;
import com.sap.cds.services.cds.CdsDeleteEventContext;
import com.sap.cds.services.cds.CdsReadEventContext;
import com.sap.cds.services.cds.CdsUpdateEventContext;
import com.sap.cds.services.draft.DraftAdministrativeData;
import com.sap.cds.services.draft.DraftCancelEventContext;
import com.sap.cds.services.draft.DraftCreateEventContext;
import com.sap.cds.services.draft.DraftEditEventContext;
import com.sap.cds.services.draft.DraftGcEventContext;
import com.sap.cds.services.draft.DraftNewEventContext;
import com.sap.cds.services.draft.DraftPatchEventContext;
import com.sap.cds.services.draft.DraftPrepareEventContext;
import com.sap.cds.services.draft.DraftSaveEventContext;
import com.sap.cds.services.draft.DraftService;
import com.sap.cds.services.draft.Drafts;
import com.sap.cds.services.handler.EventHandler;
import com.sap.cds.services.handler.annotations.After;
import com.sap.cds.services.handler.annotations.Before;
import com.sap.cds.services.handler.annotations.HandlerOrder;
import com.sap.cds.services.handler.annotations.On;
import com.sap.cds.services.handler.annotations.ServiceName;
import com.sap.cds.services.impl.cds.CapabilitiesHandler;
import com.sap.cds.services.impl.draft.CqnAdapter;
import com.sap.cds.services.impl.draft.DraftModifier;
import com.sap.cds.services.impl.draft.DraftServiceImpl;
import com.sap.cds.services.impl.draft.ParentEntityLookup;
import com.sap.cds.services.impl.utils.CdsModelUtils;
import com.sap.cds.services.impl.utils.CdsServiceUtils;
import com.sap.cds.services.persistence.PersistenceService;
import com.sap.cds.services.request.RequestContext;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.runtime.RequestContextRunner;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.DraftUtils;
import com.sap.cds.services.utils.ErrorStatusException;
import com.sap.cds.services.utils.TenantAwareCache;
import com.sap.cds.services.utils.model.CdsAnnotations;
import com.sap.cds.services.utils.model.CqnUtils;
import com.sap.cds.util.CqnStatementUtils;
import com.sap.cds.util.OnConditionAnalyzer;
import java.text.Collator;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ServiceName(value={"*"}, type={DraftService.class})
public class DraftHandler
implements EventHandler {
    private static final Logger log = LoggerFactory.getLogger(DraftHandler.class);
    private static final String ADDED_COLUMN_PREFIX = "ADDED_FOR_DRAFT_SORTING_";
    private final TenantAwareCache<ParentEntityLookup, CdsModel> parentEntityLookups;

    public DraftHandler(CdsRuntime runtime) {
        this.parentEntityLookups = TenantAwareCache.create(() -> new ParentEntityLookup(RequestContext.getCurrent((CdsRuntime)runtime).getModel()), (CdsRuntime)runtime);
    }

    @Before(event={"DRAFT_NEW"})
    @HandlerOrder(value=-10800)
    protected void checkCapabilityNewDraft(EventContext context) {
        if (!CapabilitiesHandler.getCapabilities(context).isInsertable()) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.ENTITY_NOT_INSERTABLE, new Object[]{context.getTarget().getQualifiedName()});
        }
    }

    @Before(event={"draftEdit"})
    @HandlerOrder(value=-10800)
    protected void checkCapabilityEditDraft(EventContext context) {
        if (!CapabilitiesHandler.getCapabilities(context).isUpdatable()) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.ENTITY_NOT_UPDATABLE, new Object[]{context.getTarget().getQualifiedName()});
        }
    }

    @Before(event={"CREATE", "UPSERT", "UPDATE"})
    @HandlerOrder(value=-10600)
    protected void clearDraftFields(EventContext context) {
        CdsServiceUtils.getEntities(context).forEach(r -> CdsModelUtils.visitDeep(context.getTarget(), r, (cdsEntity, data, parent, parentData) -> {
            data.remove("HasDraftEntity");
            data.remove("HasActiveEntity");
            data.remove("SiblingEntity");
            data.remove("DraftAdministrativeData");
            data.remove("DraftAdministrativeData_DraftUUID");
            if (parentData != null && !data.values().stream().anyMatch(e -> e != null)) {
                parentData.remove(parent.getName());
            }
        }));
    }

    @Before(event={"CREATE", "UPSERT", "UPDATE"})
    @HandlerOrder(value=11200)
    protected void clearIsActiveEntity(EventContext context) {
        CdsDataProcessor.create().addConverter((p, e, t) -> e.getName().equals("IsActiveEntity"), (p, e, v) -> CdsDataProcessor.Converter.REMOVE).process(CdsServiceUtils.getEntities(context), (CdsStructuredType)context.getTarget());
    }

    @Before(service={"*"}, serviceType={PersistenceService.class}, event={"CREATE", "UPSERT", "UPDATE"})
    @HandlerOrder(value=-10600)
    protected void clearDraftFieldsOnPersistenceService(EventContext context) {
        if (DraftUtils.isDraftEnabled((CdsEntity)context.getTarget()) && !context.getTarget().getQualifiedName().endsWith("_drafts")) {
            this.clearDraftFields(context);
        }
    }

    @Before(event={"draftActivate", "draftEdit", "draftPrepare"})
    @HandlerOrder(value=-10800)
    protected void checkRootDraft(EventContext context) {
        if (!DraftUtils.isDraftEnabled((CdsEntity)context.getTarget())) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.ENTITY_NOT_DRAFT_ENABLED, new Object[]{context.getTarget().getQualifiedName()});
        }
        if (!DraftUtils.isDraftEnabledNoChild((CdsEntity)context.getTarget())) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.ENTITY_NOT_ROOT, new Object[]{context.getTarget().getQualifiedName()});
        }
    }

    @Before(event={"DRAFT_CANCEL", "DRAFT_NEW", "DRAFT_PATCH"})
    @HandlerOrder(value=-10800)
    protected void checkDraft(EventContext context) {
        if (!DraftUtils.isDraftEnabled((CdsEntity)context.getTarget())) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.ENTITY_NOT_DRAFT_ENABLED, new Object[]{context.getTarget().getQualifiedName()});
        }
    }

    @After
    protected void updateAdminDataOnNewDraft(DraftNewEventContext context) {
        if (DraftUtils.isDraftEnabled((CdsEntity)context.getTarget()) && !DraftUtils.isDraftEnabledNoChild((CdsEntity)context.getTarget())) {
            this.updateDraftAdministrativeDataChangeTime(context.getResult(), (EventContext)context);
        }
    }

    @Before
    protected void updateAdminDataOnDeletion(DraftCancelEventContext context) {
        if (DraftUtils.isDraftEnabled((CdsEntity)context.getTarget()) && !DraftUtils.isDraftEnabledNoChild((CdsEntity)context.getTarget())) {
            Select select = CqnAdapter.toSelect(context.getCqn()).columns(new String[]{"DraftAdministrativeData_DraftUUID"});
            select = (CqnSelect)CQL.copy((CqnStatement)select, (Modifier)new CqnModifier(){

                public Predicate where(Predicate where) {
                    Predicate isActiveEntityFalse = CQL.get((String)"IsActiveEntity").eq((Object)false);
                    if (where == null) {
                        return isActiveEntityFalse;
                    }
                    return CQL.and((CqnPredicate)where, (CqnPredicate)isActiveEntityFalse);
                }
            });
            this.updateDraftAdministrativeDataChangeTime(this.read((CqnSelect)select, (EventContext)context), (EventContext)context);
        }
    }

    private void updateDraftAdministrativeDataChangeTime(Result result, EventContext context) {
        Instant now = Instant.now();
        List updates = result.stream().map(row -> row.get((Object)"DraftAdministrativeData_DraftUUID")).distinct().map(uuid -> ImmutableMap.of((Object)"DraftUUID", (Object)uuid, (Object)"LastChangeDateTime", (Object)now)).collect(Collectors.toList());
        if (!updates.isEmpty()) {
            PersistenceService persistenceService = (PersistenceService)context.getCdsRuntime().getServiceCatalog().getService(PersistenceService.class, "PersistenceService$Default");
            persistenceService.run((CqnUpdate)Update.entity((String)"DRAFT.DraftAdministrativeData").entries(updates), new Object[0]);
        }
    }

    @On
    @HandlerOrder(value=11000)
    protected Result defaultNew(DraftNewEventContext context) {
        Insert insert = Insert.copy((CqnInsert)context.getCqn());
        insert.entries().stream().forEach(m -> this.addDraftFields((Map<String, Object>)m, false, context.getTarget(), (EventContext)context, context.getCqn().ref()));
        Result result = ((DraftServiceImpl)context.getService()).createDraft((CqnInsert)insert);
        if (!DraftUtils.isDraftEnabledNoChild((CdsEntity)context.getTarget())) {
            List<ParentEntityLookup.ParentEntityLookupResult> parentLookups = ((ParentEntityLookup)this.parentEntityLookups.findOrCreate()).lookupParent(context.getTarget());
            if (parentLookups == null || parentLookups.isEmpty()) {
                throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.NO_PARENT_ENTITY, new Object[]{context.getTarget().getQualifiedName()});
            }
            result.forEach(r -> {
                int numberParents = 0;
                for (ParentEntityLookup.ParentEntityLookupResult parentLookup : parentLookups) {
                    if (!DraftUtils.isDraftEnabled((CdsEntity)parentLookup.getParentEntity())) continue;
                    String compositionName = parentLookup.getComposition().getName();
                    Predicate pred = CQL.get((String)"IsActiveEntity").eq((Object)false);
                    for (Map.Entry<String, Object> key : DraftHandler.getKeys((Map<String, Object>)r, context.getTarget()).entrySet()) {
                        Predicate tmpPred = CQL.to((String)compositionName).get(key.getKey()).eq(key.getValue());
                        pred = CQL.and((CqnPredicate)pred, (CqnPredicate)tmpPred);
                    }
                    Select select = Select.from((CdsEntity)parentLookup.getParentEntity()).where((CqnPredicate)pred);
                    Result result2 = this.read((CqnSelect)select, (EventContext)context);
                    if (!result2.first().isPresent()) continue;
                    ++numberParents;
                }
                if (numberParents == 0) {
                    throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.PARENT_NOT_EXISTING, new Object[]{context.getTarget().getQualifiedName()});
                }
                if (numberParents > 1) {
                    throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.MULTIPLE_PARENTS, new Object[]{numberParents, context.getTarget().getQualifiedName()});
                }
            });
        }
        return result;
    }

    @On
    @HandlerOrder(value=11000)
    protected Result defaultSave(DraftSaveEventContext context) {
        Select select = Select.copy((CqnSelect)context.getCqn()).columns((Function[])DraftHandler.expandCompositions(context.getTarget()));
        Result toSave = this.read((CqnSelect)select, (EventContext)context);
        CdsDataProcessor.create().addGenerator((p, e, t) -> t.isSimple(), (p, e, n) -> null).process((Iterable)toSave, (CdsStructuredType)context.getTarget());
        if (toSave.rowCount() == 0L) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.ENTITY_INSTANCE_NOT_FOUND, new Object[]{context.getTarget().getQualifiedName(), com.sap.cds.services.utils.model.CdsModelUtils.getTargetKeysAsString((CdsModel)context.getModel(), (CqnStatement)select)});
        }
        ArrayList newEntities = new ArrayList();
        ArrayList existingEntities = new ArrayList();
        toSave.forEach(r -> {
            if (!Boolean.FALSE.equals(r.get((Object)"IsActiveEntity"))) {
                throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.ENTITY_NOT_INACTIVE, new Object[0]);
            }
            if (((Boolean)r.get((Object)"HasActiveEntity")).booleanValue()) {
                existingEntities.add(r);
            } else {
                newEntities.add(r);
            }
        });
        Delete<?> delete = CqnAdapter.toDelete((CqnSelect)select);
        Result deleteResult = this.cancel((CqnDelete)delete, (EventContext)context, (Iterable<Map<String, Object>>)(context.getCqnNamedValues() != null ? Arrays.asList(context.getCqnNamedValues()) : Collections.emptyList()));
        if (deleteResult.rowCount() != toSave.rowCount()) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.ENTITY_NOT_INACTIVE, new Object[0]);
        }
        Result result = null;
        if (!newEntities.isEmpty()) {
            Insert insert = Insert.into((CdsEntity)context.getTarget()).entries(newEntities);
            result = context.getService().run((CqnInsert)insert);
        }
        if (!existingEntities.isEmpty()) {
            Update update = Update.entity((CdsEntity)context.getTarget()).entries(existingEntities);
            result = DraftHandler.mergeInsertResults(result, context.getService().run((CqnUpdate)update, new Object[0]));
        }
        DraftHandler.adaptSaveResult(result, context.getTarget());
        return result;
    }

    @On
    @HandlerOrder(value=11000)
    protected Result defaultEdit(DraftEditEventContext context) {
        Select select = Select.copy((CqnSelect)context.getCqn()).columns((Function[])DraftHandler.expandCompositions(context.getTarget()));
        Result toEdit = (Result)context.getCdsRuntime().requestContext().modifyParameters(param -> param.setLocale(null)).run(arg_0 -> this.lambda$defaultEdit$14((CqnSelect)select, context, arg_0));
        if (toEdit.rowCount() == 0L) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.ENTITY_INSTANCE_NOT_FOUND, new Object[]{context.getTarget().getQualifiedName(), com.sap.cds.services.utils.model.CdsModelUtils.getTargetKeysAsString((CdsModel)context.getModel(), (CqnStatement)select)});
        }
        toEdit.forEach(r -> {
            if (!Boolean.TRUE.equals(r.get((Object)"IsActiveEntity"))) {
                throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.ENTITY_NOT_ACTIVE, new Object[0]);
            }
            DraftHandler.clearOnUpdateFields((Map<String, Object>)r, context.getTarget());
            this.addDraftFields((Map<String, Object>)r, true, context.getTarget(), (EventContext)context, context.getCqn().ref());
        });
        if (context.getPreserveChanges() != null && !context.getPreserveChanges().booleanValue()) {
            CqnDelete delete = CqnAdapter.toDelete(context.getCqn());
            delete = CqnAdapter.replaceIsActiveEntity(delete, true);
            CqnDelete deleteStatement = delete = this.addTimeoutConstraint(delete, (EventContext)context);
            this.privileged((EventContext)context).run(requestContext -> context.getService().cancelDraft(deleteStatement, new Object[0]));
        }
        Insert insert = Insert.into((String)context.getTarget().getQualifiedName()).entries((Iterable)toEdit);
        Result result = ((DraftServiceImpl)context.getService()).createDraft((CqnInsert)insert);
        return result;
    }

    @On
    @HandlerOrder(value=11000)
    protected Result defaultPatch(DraftPatchEventContext context) {
        CqnUpdate update = context.getCqn();
        update = this.addSecurityConstraints(update, (EventContext)context);
        List<CqnUpdate> statements = this.removeActiveTargets(CqnAdapter.adapt(update, (EventContext)context), (EventContext)context);
        return this.execute(statements, context.getCqnValueSets(), (EventContext)context);
    }

    @On
    @HandlerOrder(value=11000)
    protected Result defaultPrepare(DraftPrepareEventContext context) {
        Result result = context.getService().run(context.getCqn(), new Object[0]);
        if (result.rowCount() == 0L) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.ENTITY_INSTANCE_NOT_FOUND, new Object[]{context.getTarget().getQualifiedName(), com.sap.cds.services.utils.model.CdsModelUtils.getTargetKeysAsString((CdsModel)context.getModel(), (CqnStatement)context.getCqn())});
        }
        result.forEach(r -> {
            if (!Boolean.FALSE.equals(r.get((Object)"IsActiveEntity"))) {
                throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.ENTITY_NOT_INACTIVE, new Object[0]);
            }
        });
        return result;
    }

    @On
    @HandlerOrder(value=11000)
    protected Result defaultCancel(DraftCancelEventContext context) {
        return this.cancel(context.getCqn(), (EventContext)context, context.getCqnValueSets());
    }

    @On
    @HandlerOrder(value=10900)
    protected void defaultRead(CdsReadEventContext context) {
        context.setResult((Iterable)this.read(context.getCqn(), context.getCqnNamedValues(), (EventContext)context));
    }

    @On
    @HandlerOrder(value=10900)
    protected void defaultUpdate(CdsUpdateEventContext context) {
        if (DraftUtils.isDraftEnabled((CdsEntity)context.getTarget())) {
            CqnUpdate update = context.getCqn();
            AnalysisResult entityPath = CdsModelUtils.getEntityPath((CqnStatement)context.getCqn(), context.getModel());
            CqnUpdate updateActive = this.addLockingConstraints((CqnUpdate)Update.copy((CqnUpdate)update), (EventContext)context, entityPath);
            List<CqnUpdate> stmts = this.removeDraftTargets(CqnAdapter.adapt(updateActive, (EventContext)context), (EventContext)context);
            context.setResult((Iterable)this.execute(stmts, context.getCqnValueSets(), (EventContext)context));
        }
    }

    @On
    @HandlerOrder(value=10900)
    protected void defaultDelete(CdsDeleteEventContext context) {
        if (DraftUtils.isDraftEnabled((CdsEntity)context.getTarget())) {
            DraftService service = (DraftService)context.getService();
            Result result = this.execute(this.removeDraftTargets(CqnAdapter.adapt(context.getCqn(), (EventContext)context), (EventContext)context), (EventContext)context, context.getCqnValueSets());
            Result resultDraft = null;
            if (result.rowCount() > 0L) {
                for (CqnDelete d : CqnAdapter.adaptActiveEntity(context.getCqn(), (EventContext)context)) {
                    Result deleteResult = (Result)this.privileged((EventContext)context).run(requestContext -> service.cancelDraft(d, new Object[0]));
                    long[] deleteCount = this.addRowCounts(deleteResult, resultDraft);
                    resultDraft = ResultBuilder.deletedRows((long[])deleteCount).result();
                }
            }
            long[] deleteCount = this.addRowCounts(result, resultDraft);
            result = ResultBuilder.deletedRows((long[])deleteCount).result();
            context.setResult((Iterable)result);
        }
    }

    @On
    @HandlerOrder(value=11000)
    protected Result createDraft(DraftCreateEventContext context) {
        List<CqnInsert> inserts = CqnAdapter.adapt(context.getCqn(), (EventContext)context);
        this.removeActiveTargets(inserts, (EventContext)context);
        if (inserts.size() > 1) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.MISSING_ISACTIVEENTITY_KEY, new Object[0]);
        }
        return CdsServiceUtils.getDefaultPersistenceService((EventContext)context).run(inserts.get(0));
    }

    @After(event={"CREATE", "UPSERT", "UPDATE"})
    @HandlerOrder(value=-11000)
    protected void addActiveDraftFields(EventContext context) {
        List result = CdsServiceUtils.getResult(context).list();
        CdsModelUtils.visitDeep(context.getTarget(), result, (cdsEntity, data, parent) -> {
            if (DraftUtils.isDraftEnabled((CdsEntity)cdsEntity)) {
                data.forEach(m -> {
                    m.put("IsActiveEntity", true);
                    m.put("HasActiveEntity", false);
                    m.put("HasDraftEntity", false);
                });
            }
        });
    }

    @Before(event={"DRAFT_PATCH"})
    protected void updateDraftAdministrativeData(DraftPatchEventContext context) {
        List entries = context.getCqn().entries();
        Instant now = Instant.now();
        CdsModelUtils.visitDeep(context.getTarget(), entries, (entity, data, parent) -> {
            if (entity.findElement("DraftAdministrativeData").isPresent()) {
                if (!entity.getQualifiedName().equals(context.getTarget().getQualifiedName())) {
                    throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.DRAFT_DEEP_UPDATE, new Object[0]);
                }
                data.forEach(row -> {
                    DraftAdministrativeData adminData;
                    if (row.containsKey("DraftAdministrativeData")) {
                        adminData = (DraftAdministrativeData)Struct.access((Map)((Map)row.get("DraftAdministrativeData"))).as(DraftAdministrativeData.class);
                    } else {
                        adminData = (DraftAdministrativeData)Struct.create(DraftAdministrativeData.class);
                        row.put("DraftAdministrativeData", adminData);
                    }
                    adminData.setLastChangeDateTime(now);
                });
            }
        });
    }

    private RequestContextRunner privileged(EventContext context) {
        return context.getCdsRuntime().requestContext().privilegedUser().recalculateFeatureToggles();
    }

    private CqnUpdate addSecurityConstraints(CqnUpdate update, EventContext context) {
        CqnPredicate predicate = CqnAdapter.getSecurityConstraints(context);
        return (CqnUpdate)CqnUtils.modifiedWhere((CqnStatement)update, (Function)CqnUtils.andPredicate((CqnPredicate)predicate));
    }

    private CqnDelete addSecurityConstraints(CqnDelete delete, EventContext context) {
        CqnPredicate predicate = CqnAdapter.getSecurityConstraints(context);
        return (CqnDelete)CqnUtils.modifiedWhere((CqnStatement)delete, (Function)CqnUtils.andPredicate((CqnPredicate)predicate));
    }

    private CqnUpdate addLockingConstraints(CqnUpdate update, EventContext context, AnalysisResult entityPath) {
        if (!context.getCdsRuntime().getEnvironment().getCdsProperties().getSecurity().getDraftProtection().isEnabled().booleanValue()) {
            return update;
        }
        String draftEntity = CqnAdapter.getDraftsEntity(entityPath.targetEntity().getQualifiedName());
        List keys = entityPath.targetEntity().keyElements().filter(e -> !e.getType().isAssociation() && !e.isVirtual() && !e.getName().equals("IsActiveEntity")).collect(Collectors.toList());
        CqnPredicate predicate = (CqnPredicate)Select.from((String)"").where(c -> c.exists(o -> Select.from((String)draftEntity).where(i -> DraftHandler.createExistsDraftCondition(o, i, keys))).not()).where().get();
        return (CqnUpdate)CqnUtils.modifiedWhere((CqnStatement)update, (Function)CqnUtils.andPredicate((CqnPredicate)predicate));
    }

    private static CqnPredicate createExistsDraftCondition(StructuredType<?> outer, StructuredType<?> inner, List<CdsElement> keys) {
        ArrayList<Predicate> predicates = new ArrayList<Predicate>(keys.size());
        for (CdsElement key : keys) {
            predicates.add(outer.get(key.getName()).eq((Value)inner.get(key.getName())));
        }
        return CQL.and(predicates);
    }

    private CqnDelete addTimeoutConstraint(CqnDelete delete, EventContext context) {
        Instant timeoutThreshold = DraftModifier.getCancellationThreshold(context);
        CqnPredicate predicate = (CqnPredicate)Select.from((String)"").where(c -> c.exists(b -> Select.from((String)"DRAFT.DraftAdministrativeData").where(e -> e.get("DraftUUID").eq((Value)b.get("DraftAdministrativeData_DraftUUID")).and((CqnPredicate)e.get("LastChangeDateTime").le((Object)timeoutThreshold), new CqnPredicate[0])))).where().get();
        return (CqnDelete)CqnUtils.modifiedWhere((CqnStatement)delete, (Function)CqnUtils.andPredicate((CqnPredicate)predicate));
    }

    private Result cancel(CqnDelete delete, EventContext context, Iterable<Map<String, Object>> valueSets) {
        delete = this.addSecurityConstraints(delete, context);
        List<CqnDelete> statements = this.removeActiveTargets(CqnAdapter.adapt(delete, context), context);
        return this.execute(statements, context, valueSets);
    }

    private <T extends CqnStatement> List<T> removeActiveTargets(List<T> statements, EventContext context) {
        statements.removeIf(d -> !CdsModelUtils.getEntityPath(d.ref(), context.getModel()).targetEntity().getQualifiedName().endsWith("_drafts"));
        return statements;
    }

    private <T extends CqnStatement> List<T> removeDraftTargets(List<T> statements, EventContext context) {
        statements.removeIf(d -> CdsModelUtils.getEntityPath(d.ref(), context.getModel()).targetEntity().getQualifiedName().endsWith("_drafts"));
        return statements;
    }

    private Result read(CqnSelect select, Map<String, Object> cqnNamedValues, EventContext context) {
        Map<CqnValue, String> addedItems = DraftHandler.addMissingItems(select, select.orderBy());
        List<CqnSelect> statements = CqnAdapter.adapt(select, context);
        Result result = this.execute(select, statements, context, cqnNamedValues, addedItems);
        DraftHandler.removeAddedItems(addedItems, result);
        result = this.setRowType(select, context, result);
        return result;
    }

    private Result setRowType(CqnSelect select, EventContext context, Result result) {
        CdsStructuredType rowType = CqnStatementUtils.rowType((CdsModel)context.getModel(), (CqnSelect)select);
        return ResultBuilder.selectedRows((List)result.list()).inlineCount(result.inlineCount()).rowType(rowType).result();
    }

    private Result execute(List<CqnDelete> statements, EventContext context, Iterable<Map<String, Object>> valueSets) {
        return this.execute((CqnStatement d, PersistenceService service) -> service.run((CqnDelete)d, valueSets), statements, context);
    }

    private Result execute(List<CqnUpdate> statements, Iterable<Map<String, Object>> valueSets, EventContext context) {
        return this.execute((CqnStatement u, PersistenceService service) -> service.run((CqnUpdate)u, valueSets), statements, context);
    }

    /*
     * WARNING - void declaration
     */
    private Result execute(BiFunction<CqnStatement, PersistenceService, Result> executor, List<? extends CqnStatement> statements, EventContext context) {
        void var8_10;
        PersistenceService service = CdsServiceUtils.getDefaultPersistenceService(context);
        ArrayList<Row> rows = new ArrayList<Row>();
        ArrayList<Long> rowCount = new ArrayList<Long>();
        for (CqnStatement cqnStatement : statements) {
            Result result = executor.apply(cqnStatement, service);
            if (rows.isEmpty()) {
                rows.addAll(result.list());
            } else {
                List resultList = result.list();
                for (int i = 0; i < resultList.size(); ++i) {
                    Row row = (Row)resultList.get(i);
                    if (row.isEmpty()) continue;
                    rows.set(i, row);
                }
            }
            for (int i = 0; i < result.batchCount(); ++i) {
                if (rowCount.size() > i) {
                    rowCount.set(i, (Long)rowCount.get(i) + result.rowCount(i));
                    continue;
                }
                rowCount.add(result.rowCount(i));
            }
        }
        long[] rowCountArray = new long[rowCount.size()];
        boolean bl = false;
        while (var8_10 < rowCount.size()) {
            rowCountArray[var8_10] = (Long)rowCount.get((int)var8_10);
            ++var8_10;
        }
        if (rows.isEmpty()) {
            return ResultBuilder.deletedRows((long[])rowCountArray).result();
        }
        ResultBuilder resultBuilder = ResultBuilder.batchUpdate();
        for (int i = 0; i < rowCountArray.length; ++i) {
            resultBuilder.addUpdatedRows(rowCountArray[i], (Map)rows.get(i));
        }
        return resultBuilder.result();
    }

    private Result execute(CqnSelect select, List<CqnSelect> statements, EventContext context, Map<String, Object> cqnNamedValues, Map<CqnValue, String> addedItems) {
        if (!select.orderBy().isEmpty() || select.hasLimit()) {
            ArrayList<CqnSelect> draftStatements = new ArrayList<CqnSelect>(statements);
            ArrayList<CqnSelect> activeStatements = new ArrayList<CqnSelect>(statements);
            this.removeActiveTargets(draftStatements, context);
            this.removeDraftTargets(activeStatements, context);
            draftStatements.forEach(s -> ((SelectBuilder)s).limit(-1L, 0L));
            Result draftResult = this.executePlain(draftStatements, context, cqnNamedValues);
            long numDrafts = draftResult.rowCount();
            long skipDiff = 0L;
            long oldTop = 0L;
            if (select.hasLimit()) {
                long oldSkip = select.skip();
                oldTop = select.top();
                long newSkip = Math.max(0L, oldSkip - numDrafts);
                long newTop = Math.max(oldTop + numDrafts, oldTop);
                skipDiff = oldSkip - newSkip;
                activeStatements.forEach(s -> ((Select)s).limit(newTop, newSkip));
            }
            Result activeResult = this.executePlain(activeStatements, context, cqnNamedValues);
            List<Row> orderedResult = DraftHandler.sortResults(context, activeResult, draftResult, select.orderBy(), addedItems);
            if (select.hasLimit()) {
                long newEnd = Math.max(oldTop + skipDiff, oldTop);
                long end = Math.min(newEnd, (long)orderedResult.size());
                orderedResult = orderedResult.subList((int)skipDiff, (int)end);
            }
            return ResultBuilder.selectedRows(orderedResult).inlineCount(DraftHandler.calcInlineCount(draftResult, activeResult)).result();
        }
        return this.executePlain(statements, context, cqnNamedValues);
    }

    private static long calcInlineCount(Result draftResult, Result activeResult) {
        long inlineCount = activeResult.inlineCount();
        if (inlineCount < 0L) {
            inlineCount = draftResult.inlineCount();
        } else if (draftResult.inlineCount() >= 0L) {
            inlineCount += draftResult.inlineCount();
        }
        return inlineCount;
    }

    private static void removeAddedItems(Map<CqnValue, String> addedItems, Result orderedResult) {
        if (addedItems != null && !addedItems.isEmpty()) {
            orderedResult.forEach(row -> addedItems.values().forEach(item -> row.remove(item)));
        }
    }

    private static Map<CqnValue, String> addMissingItems(CqnSelect select, List<CqnSortSpecification> sortSpecifications) {
        List items = select.items();
        if (!items.isEmpty() && !items.stream().anyMatch(i -> i.isStar())) {
            List itemNames = items.stream().filter(i -> i.isValue()).map(i -> i.asValue().displayName()).collect(Collectors.toList());
            List missingItems = sortSpecifications.stream().map(spec -> spec.value()).filter(item -> !item.isRef() || !itemNames.contains(item.asRef().displayName())).collect(Collectors.toList());
            HashMap<CqnValue, String> addedItems = new HashMap<CqnValue, String>();
            if (!missingItems.isEmpty()) {
                ArrayList<CqnSelectListValue> newItems = new ArrayList<CqnSelectListValue>(items.size() + missingItems.size());
                newItems.addAll(items);
                int i2 = 0;
                for (CqnValue item2 : missingItems) {
                    String addedItemName = ADDED_COLUMN_PREFIX + ++i2;
                    addedItems.put(item2, addedItemName);
                    newItems.add(SelectListValueBuilder.select((CqnValue)item2).as(addedItemName).build());
                }
                ((Select)select).columns(newItems);
            }
            return addedItems;
        }
        return null;
    }

    private static String getItemName(CqnSortSpecification spec) {
        return spec.value().asRef().displayName();
    }

    private static String getItemName(CqnSortSpecification spec, Map<CqnValue, String> addedItems) {
        String changedName = null;
        if (addedItems != null) {
            changedName = addedItems.get(spec.value());
        }
        if (changedName != null) {
            return changedName;
        }
        return DraftHandler.getItemName(spec);
    }

    private static List<Row> sortResults(EventContext context, Result active, Result draft, List<CqnSortSpecification> sortSpecifications, Map<CqnValue, String> addedItems) {
        Row rDraft;
        CdsEntity entity = context.getTarget();
        ArrayList<Row> result = new ArrayList<Row>((int)(active.rowCount() + draft.rowCount()));
        Iterator activeIter = active.iterator();
        Iterator draftIter = draft.iterator();
        Row rActive = activeIter.hasNext() ? (Row)activeIter.next() : null;
        Row row = rDraft = draftIter.hasNext() ? (Row)draftIter.next() : null;
        while (rActive != null || rDraft != null) {
            int comparison = Objects.compare(rDraft, rActive, (o1, o2) -> {
                if (o1 == null) {
                    return 1;
                }
                if (o2 == null) {
                    return -1;
                }
                for (CqnSortSpecification spec : sortSpecifications) {
                    int comp;
                    String item = DraftHandler.getItemName(spec, addedItems);
                    int orderFactor = spec.order() == CqnSortSpecification.Order.DESC ? -1 : 1;
                    Object value1 = o1.get((Object)item);
                    Object value2 = o2.get((Object)item);
                    if (value1 == null && value2 == null) continue;
                    if (value1 == null) {
                        return -orderFactor;
                    }
                    if (value2 == null) {
                        return orderFactor;
                    }
                    if (!(value1 instanceof Comparable) || !(value2 instanceof Comparable)) {
                        throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.INVALID_SORT_ELEMENT, new Object[]{item, entity.getQualifiedName()});
                    }
                    Locale locale = context.getParameterInfo().getLocale();
                    if (value1 instanceof String && value2 instanceof String && locale != null) {
                        Collator collator = Collator.getInstance(locale);
                        comp = collator.compare(value1, value2);
                    } else {
                        comp = ((Comparable)value1).compareTo(value2);
                    }
                    if (comp == 0) continue;
                    return orderFactor * comp;
                }
                if (o1.containsKey((Object)"IsActiveEntity") && ((Boolean)o1.get((Object)"IsActiveEntity")).booleanValue()) {
                    if (o2.containsKey((Object)"IsActiveEntity") && ((Boolean)o2.get((Object)"IsActiveEntity")).booleanValue()) {
                        return 0;
                    }
                    return 1;
                }
                if (o2.containsKey((Object)"IsActiveEntity") && ((Boolean)o2.get((Object)"IsActiveEntity")).booleanValue()) {
                    return -1;
                }
                return 0;
            });
            if (comparison > 0) {
                result.add(rActive);
                if (activeIter.hasNext()) {
                    rActive = (Row)activeIter.next();
                    continue;
                }
                rActive = null;
                continue;
            }
            result.add(rDraft);
            if (draftIter.hasNext()) {
                rDraft = (Row)draftIter.next();
                continue;
            }
            rDraft = null;
        }
        return result;
    }

    private Result executePlain(List<CqnSelect> statements, EventContext context, Map<String, Object> cqnNamedValues) {
        PersistenceService service = CdsServiceUtils.getDefaultPersistenceService(context);
        Object result = null;
        long inlineCount = -1L;
        for (CqnSelect select : statements) {
            Result tmpResult = service.run(select, cqnNamedValues);
            result = result == null ? tmpResult : Iterables.concat((Iterable)result, (Iterable)tmpResult);
            if (tmpResult.inlineCount() < 0L) continue;
            if (inlineCount < 0L) {
                inlineCount = tmpResult.inlineCount();
                continue;
            }
            inlineCount += tmpResult.inlineCount();
        }
        if (result == null) {
            return ResultBuilder.selectedRows(Collections.emptyList()).result();
        }
        ArrayList resultList = Lists.newArrayList(result);
        DraftHandler.mergeExpands(resultList, context);
        return ResultBuilder.selectedRows((List)resultList).inlineCount(inlineCount).result();
    }

    private static void mergeExpands(List<Row> resultList, EventContext context) {
        CdsModelUtils.visitDeep(context.getTarget(), resultList, (entity, data, parent) -> data.forEach(r -> entity.associations().filter(a -> a.getName().endsWith("_drafts")).forEach(a -> {
            String name = a.getName();
            if (r.containsKey(name) && r.get(name) != null) {
                String plainName = name.substring(0, name.length() - "_drafts".length());
                if (r.get(name) instanceof List) {
                    if (r.get(plainName) != null) {
                        ((List)r.get(plainName)).addAll((List)r.get(name));
                    } else {
                        r.put(plainName, r.get(name));
                    }
                } else if (r.get(plainName) == null) {
                    r.put(plainName, r.get(name));
                }
            }
            r.remove(name);
        })));
    }

    private Result read(CqnSelect select, EventContext context) {
        return this.read(select, Collections.emptyMap(), context);
    }

    private long[] addRowCounts(Result ... results) {
        long[] result = new long[]{};
        if (results.length == 0) {
            return result;
        }
        for (Result r : results) {
            if (r == null) continue;
            if (result.length == 0) {
                result = new long[r.batchCount()];
            }
            for (int i = 0; i < result.length; ++i) {
                int n = i;
                result[n] = result[n] + r.rowCount(i);
            }
        }
        return result;
    }

    private static Map<String, Object> getKeys(Map<String, Object> m, CdsEntity entity) {
        HashMap<String, Object> result = new HashMap<String, Object>(m);
        result.entrySet().removeIf(entry -> entity.findElement((String)entry.getKey()).map(e -> e.isKey()).orElse(false) == false && !"IsActiveEntity".equals(entry.getKey()));
        if ((long)result.size() != entity.keyElements().filter(element -> !element.getType().isAssociation()).count()) {
            log.error("Failed to find keys of {} in result {}", (Object)entity, m);
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.NO_KEYS_IN_RESULT, new Object[]{entity});
        }
        return result;
    }

    private static void clearOnUpdateFields(Map<String, Object> m, CdsEntity entity) {
        CdsModelUtils.visitDeep(entity, m, (cdsEntity, data, parent, parentData) -> cdsEntity.elements().filter(e -> CdsAnnotations.ON_UPDATE.getOrDefault((CdsAnnotatable)e) != null).map(e -> e.getName()).forEach(e -> data.remove(e)));
    }

    private static <T> Function<T, CqnSelectListItem>[] expandCompositions(CdsEntity entity) {
        ArrayList<Function<StructuredType, CqnSelectListItem>> columns = new ArrayList<Function<StructuredType, CqnSelectListItem>>();
        columns.add(c -> c._all());
        entity.compositions().forEach(co -> columns.add(c -> c.to(co.getName()).expand((Function[])DraftHandler.expandCompositions(entity.getTargetOf(co.getName())))));
        return columns.toArray(new Function[columns.size()]);
    }

    private void addDraftFields(Map<String, Object> m, boolean hasActiveEntity, CdsEntity entity, EventContext context, CqnStructuredTypeRef ref) {
        String draftUUID = this.determineDraftUuid(m, entity, context, ref);
        CdsModelUtils.visitDeep(entity, m, (cdsEntity, mapData, parent, parentData) -> {
            if (parent != null && !((CdsAssociationType)parent.getType().as(CdsAssociationType.class)).isComposition()) {
                return;
            }
            Drafts draft = (Drafts)Struct.access((Map)mapData).as(Drafts.class);
            draft.setHasActiveEntity(Boolean.valueOf(hasActiveEntity));
            draft.setHasDraftEntity(Boolean.valueOf(false));
            draft.setIsActiveEntity(Boolean.valueOf(false));
            draft.setDraftAdministrativeDataDraftUuid(draftUUID);
            if (DraftUtils.isDraftEnabledNoChild((CdsEntity)cdsEntity)) {
                DraftAdministrativeData data = (DraftAdministrativeData)Struct.create(DraftAdministrativeData.class);
                String userName = context.getUserInfo().getName();
                data.setCreatedByUser(userName);
                data.setDraftUUID(draftUUID);
                Instant now = Instant.now();
                data.setCreationDateTime(now);
                data.setLastChangeDateTime(now);
                data.setInProcessByUser(userName);
                data.setLastChangedByUser(userName);
                draft.setDraftAdministrativeData((Map)data);
            }
        });
    }

    private String determineDraftUuid(Map<String, Object> m, CdsEntity entity, EventContext context, CqnStructuredTypeRef ref) {
        CdsEntity potentialParent;
        Drafts draftData = (Drafts)Struct.access(m).as(Drafts.class);
        if (draftData.getDraftAdministrativeDataDraftUuid() != null) {
            return draftData.getDraftAdministrativeDataDraftUuid();
        }
        if (DraftUtils.isDraftEnabledNoChild((CdsEntity)entity)) {
            return UUID.randomUUID().toString();
        }
        Result result = null;
        long numParents = 0L;
        List<ParentEntityLookup.ParentEntityLookupResult> lookupResultList = ((ParentEntityLookup)this.parentEntityLookups.findOrCreate()).lookupParent(entity);
        AnalysisResult analysisResult = CdsModelUtils.getEntityPath(ref, context.getModel());
        Iterator iter = analysisResult.reverse();
        iter.next();
        CdsEntity cdsEntity = potentialParent = iter.hasNext() ? ((ResolvedSegment)iter.next()).entity() : null;
        if (potentialParent != null && lookupResultList.stream().anyMatch(lr -> lr.getParentEntity().equals(potentialParent))) {
            StructuredTypeRef newRef = ExpressionVisitor.copy((CqnStructuredTypeRef)ref, (Modifier)new CqnModifier(){

                public CqnStructuredTypeRef ref(StructuredTypeRef ref) {
                    List segmentsToParent = ref.segments().subList(0, ref.segments().size() - 1);
                    RefSegment lastSegment = (RefSegment)segmentsToParent.get(segmentsToParent.size() - 1);
                    Predicate inactive = CQL.get((String)"IsActiveEntity").eq((Object)false);
                    CqnPredicate newPred = (CqnPredicate)lastSegment.filter().map(f -> CQL.and((CqnPredicate)f, (CqnPredicate)inactive)).orElse(inactive);
                    lastSegment.filter(newPred);
                    return CQL.to(segmentsToParent).asRef();
                }
            });
            result = this.read((CqnSelect)Select.from((CqnStructuredTypeRef)newRef).columns(new String[]{"DraftAdministrativeData_DraftUUID"}), context);
            numParents = result.rowCount();
        } else {
            for (ParentEntityLookup.ParentEntityLookupResult lookupResult : lookupResultList) {
                OnConditionAnalyzer analyzer = new OnConditionAnalyzer(lookupResult.getComposition(), false);
                Map foreignKeysParent = analyzer.getFkValues(m);
                foreignKeysParent.put("IsActiveEntity", false);
                Result tmpResult = this.read((CqnSelect)Select.from((CdsEntity)lookupResult.getParentEntity()).matching(foreignKeysParent).columns(new String[]{"DraftAdministrativeData_DraftUUID"}), context);
                numParents += tmpResult.rowCount();
                if (tmpResult.first().isPresent()) {
                    result = tmpResult;
                }
                if (numParents <= 1L) continue;
                break;
            }
        }
        if (numParents > 1L) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.MULTIPLE_PARENTS, new Object[]{numParents, context.getTarget().getQualifiedName()});
        }
        if (numParents == 0L || result == null) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.PARENT_NOT_EXISTING, new Object[]{context.getTarget().getQualifiedName()});
        }
        return ((Drafts)result.single().as(Drafts.class)).getDraftAdministrativeDataDraftUuid();
    }

    private static void adaptSaveResult(Result result, CdsEntity entity) {
        result.forEach(r -> DraftHandler.removeCompositionsAndAssociations(r, entity));
    }

    private static void removeCompositionsAndAssociations(Row r, CdsEntity entity) {
        Iterator iter = r.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = (Map.Entry)iter.next();
            if (!(entry.getValue() instanceof List) && !(entry.getValue() instanceof Map) || !DraftHandler.isAssociation((String)entry.getKey(), entity)) continue;
            iter.remove();
        }
    }

    private static boolean isAssociation(String field, CdsEntity entity) {
        return entity.findAssociation(field).isPresent();
    }

    private static Result mergeInsertResults(Result result1, Result result2) {
        if (result1 == null) {
            return result2;
        }
        if (result2 == null) {
            return result1;
        }
        ArrayList entities = new ArrayList();
        entities.addAll(result1.list());
        entities.addAll(result2.list());
        return ResultBuilder.insertedRows(entities).result();
    }

    @On
    @HandlerOrder(value=11000)
    protected void onGcDrafts(DraftGcEventContext context) {
        AtomicLong numCancelledDrafts = new AtomicLong(0L);
        Instant threshold = Instant.now().minus(context.getCdsRuntime().getEnvironment().getCdsProperties().getDrafts().getDeletionTimeout()).truncatedTo(ChronoUnit.MILLIS);
        DraftService draftService = context.getService();
        draftService.getDefinition().entities().forEach(e -> {
            if (DraftUtils.isDraftEnabledNoChild((CdsEntity)e) && !e.getQualifiedName().endsWith("_drafts")) {
                Delete deleteOldDrafts = Delete.from((CdsEntity)e).where(c -> c.get("IsActiveEntity").eq((Object)false).and((CqnPredicate)c.exists(outer -> Select.from((String)"DRAFT.DraftAdministrativeData").where(a -> a.get("DraftUUID").eq((Value)outer.get("DraftAdministrativeData_DraftUUID")).and((CqnPredicate)a.get("LastChangeDateTime").le((Object)threshold), new CqnPredicate[0]))), new CqnPredicate[0]));
                Result result = (Result)this.privileged((EventContext)context).run(arg_0 -> DraftHandler.lambda$null$64(draftService, (CqnDelete)deleteOldDrafts, arg_0));
                if (result.rowCount() > 0L) {
                    log.info("Draft GC deleted {} drafts of entity '{}'", (Object)result.rowCount(), (Object)e.getQualifiedName());
                    numCancelledDrafts.addAndGet(result.rowCount());
                }
            }
        });
        context.setResult(ResultBuilder.deletedRows((long)numCancelledDrafts.get()).result());
    }

    private static /* synthetic */ Result lambda$null$64(DraftService draftService, CqnDelete deleteOldDrafts, RequestContext requestContext) {
        return draftService.cancelDraft(deleteOldDrafts, new Object[0]);
    }

    private /* synthetic */ Result lambda$defaultEdit$14(CqnSelect select, DraftEditEventContext context, RequestContext reqContext) {
        return this.read(select, (EventContext)context);
    }
}

