/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.draft;

import com.sap.cds.impl.parser.builder.ExpressionBuilder;
import com.sap.cds.ql.CQL;
import com.sap.cds.ql.ElementRef;
import com.sap.cds.ql.RefSegment;
import com.sap.cds.ql.Value;
import com.sap.cds.ql.cqn.CqnElementRef;
import com.sap.cds.ql.cqn.CqnModifier;
import com.sap.cds.ql.cqn.CqnReference;
import com.sap.cds.ql.cqn.CqnToken;
import com.sap.cds.reflect.CdsBaseType;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.services.EventContext;
import com.sap.cds.services.impl.utils.CdsModelUtils;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;

public class DraftModifier
implements CqnModifier {
    private final boolean activeEntityOnly;
    private final boolean forDraftEntity;
    private final CdsEntity entity;
    private final boolean adaptIsActiveEntity;
    private final EventContext context;

    public DraftModifier(CdsEntity entity, boolean adaptIsActiveEntity, EventContext context) {
        this(entity, false, adaptIsActiveEntity, context);
    }

    public DraftModifier(CdsEntity entity, boolean activeEntityOnly, boolean adaptIsActiveEntity, EventContext context) {
        this.entity = entity;
        this.forDraftEntity = entity.getQualifiedName().endsWith("_drafts");
        this.activeEntityOnly = activeEntityOnly;
        this.adaptIsActiveEntity = adaptIsActiveEntity;
        this.context = context;
    }

    public Value<?> ref(ElementRef<?> ref) {
        ArrayList segments = new ArrayList(ref.segments());
        if (this.referencesDraftField("IsActiveEntity", segments, this.entity, this.forDraftEntity) && this.adaptIsActiveEntity) {
            return CQL.constant((Object)true);
        }
        if (!this.activeEntityOnly) {
            if ("InProcessByUser".equals(ref.targetSegment().id())) {
                return this.createTimeoutExpression((CqnElementRef)ref);
            }
            if ("DraftIsCreatedByMe".equals(ref.targetSegment().id())) {
                return this.createDraftCreatedByMeExpression((CqnElementRef)ref);
            }
        }
        return CQL.get(segments);
    }

    private ElementRef<?> changeLastSegment(CqnElementRef ref, String id) {
        ArrayList<RefSegment> result = new ArrayList<RefSegment>(ref.segments());
        result.set(result.size() - 1, CQL.refSegment((String)id));
        return CQL.get(result);
    }

    private boolean referencesDraftField(String draftColumn, List<? extends CqnReference.Segment> segments, CdsEntity entity, boolean forDraftEntity) {
        if (segments.stream().anyMatch(s -> s.id().equalsIgnoreCase(draftColumn))) {
            for (CqnReference.Segment segment : segments) {
                String id = segment.id();
                if (draftColumn.equalsIgnoreCase(id)) {
                    return !forDraftEntity;
                }
                if (CdsModelUtils.isAssociationToParentOrChild(id, entity)) {
                    entity = entity.getTargetOf(id);
                    continue;
                }
                if ("SiblingEntity".equals(id) || "SiblingEntity_unsecured".equals(id)) {
                    forDraftEntity = !forDraftEntity;
                    continue;
                }
                if (!entity.findAssociation(id).isPresent()) continue;
                entity = entity.getTargetOf(id);
                forDraftEntity = id.endsWith("_drafts");
            }
        }
        return false;
    }

    private Value<?> createTimeoutExpression(CqnElementRef ref) {
        Instant timeoutThreshold = DraftModifier.getCancellationThreshold(this.context);
        ElementRef<?> refLastChangeDateTime = this.changeLastSegment(ref, "LastChangeDateTime");
        ElementRef<?> refDraftUuid = this.changeLastSegment(ref, "DraftUUID");
        return ExpressionBuilder.create((CqnToken[])new CqnToken[0]).plain("CASE").plain("WHEN").ref(refDraftUuid).plain("IS NULL").plain("THEN").plain("null").plain("WHEN").ref(refLastChangeDateTime).plain(">").add((CqnToken)CQL.val((Object)timeoutThreshold)).plain("THEN").ref(ref).plain("ELSE").plain("''").plain("END").value().type(CdsBaseType.STRING.cdsName());
    }

    private Value<?> createDraftCreatedByMeExpression(CqnElementRef ref) {
        String user = this.context.getUserInfo().getName();
        ElementRef<?> refCreatedByUser = this.changeLastSegment(ref, "CreatedByUser");
        return ExpressionBuilder.create((CqnToken[])new CqnToken[0]).plain("CASE").plain("WHEN").ref(refCreatedByUser).plain("=").add((CqnToken)CQL.val((Object)user)).plain("THEN").add((CqnToken)CQL.constant((Object)true)).plain("ELSE").add((CqnToken)CQL.constant((Object)false)).plain("END").value().type(CdsBaseType.BOOLEAN.cdsName());
    }

    static Instant getCancellationThreshold(EventContext context) {
        return Instant.now().minus(context.getCdsRuntime().getEnvironment().getCdsProperties().getDrafts().getCancellationTimeout()).truncatedTo(ChronoUnit.MILLIS);
    }
}

