/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.messages;

import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.ErrorStatuses;
import com.sap.cds.services.ServiceException;
import com.sap.cds.services.impl.messages.MessageImpl;
import com.sap.cds.services.messages.Message;
import com.sap.cds.services.messages.Messages;
import com.sap.cds.services.runtime.CdsRuntime;
import java.util.Locale;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.stream.Stream;

public class MessagesImpl
implements Messages {
    private ConcurrentLinkedQueue<Message> messages = new ConcurrentLinkedQueue();
    private final CdsRuntime runtime;
    private final Locale locale;

    public MessagesImpl(CdsRuntime runtime, Locale locale) {
        this.runtime = runtime;
        this.locale = locale;
    }

    public Message info(String messageOrKey, Object ... args) {
        MessageImpl message = new MessageImpl(Message.Severity.INFO, this.runtime.getLocalizedMessage(messageOrKey, args, this.locale));
        this.messages.add(message);
        return message;
    }

    public Message success(String messageOrKey, Object ... args) {
        MessageImpl message = new MessageImpl(Message.Severity.SUCCESS, this.runtime.getLocalizedMessage(messageOrKey, args, this.locale));
        this.messages.add(message);
        return message;
    }

    public Message warn(String messageOrKey, Object ... args) {
        MessageImpl message = new MessageImpl(Message.Severity.WARNING, this.runtime.getLocalizedMessage(messageOrKey, args, this.locale));
        this.messages.add(message);
        return message;
    }

    public Message error(String messageOrKey, Object ... args) {
        MessageImpl message = new MessageImpl(Message.Severity.ERROR, this.runtime.getLocalizedMessage(messageOrKey, args, this.locale));
        this.messages.add(message);
        return message;
    }

    public void throwIfError() throws ServiceException {
        this.messages.stream().filter(m -> m.getSeverity().equals((Object)Message.Severity.ERROR)).findFirst().ifPresent(error -> {
            this.messages.remove(error);
            ErrorStatus status = new ErrorStatus((Message)error){
                final /* synthetic */ Message val$error;
                {
                    this.val$error = message;
                }

                public String getCodeString() {
                    return this.val$error.getCode() != null ? this.val$error.getCode() : String.valueOf(this.getHttpStatus());
                }

                public int getHttpStatus() {
                    return ErrorStatuses.BAD_REQUEST.getHttpStatus();
                }
            };
            ServiceException exception = new ServiceException(status, error.getMessage(), new Object[0]);
            exception.messageTarget(error.getTarget());
            throw exception;
        });
    }

    public Stream<Message> stream() {
        return this.messages.stream();
    }
}

