/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.messaging.file;

import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileBasedMessagingBroker {
    private static final Logger logger = LoggerFactory.getLogger(FileBasedMessagingBroker.class);
    private static Set<String> createdBrokers = new HashSet<String>();
    private final File file;
    private final WatchService fileWatcher;
    private final Map<String, List<String>> subscriptions = new HashMap<String, List<String>>();
    private final Map<String, List<QueueListener>> listeners = new HashMap<String, List<QueueListener>>();

    private FileBasedMessagingBroker(String name, File exchangeFile) throws IOException {
        this.file = new File(exchangeFile.getCanonicalPath());
        this.fileWatcher = FileSystems.getDefault().newWatchService();
        Path dir = Paths.get(this.file.getParentFile().getAbsolutePath(), new String[0]);
        dir.register(this.fileWatcher, StandardWatchEventKinds.ENTRY_MODIFY);
        new Thread(() -> {
            WatchKey watchKey = null;
            while (true) {
                try {
                    while (true) {
                        if ((watchKey = this.fileWatcher.poll(10L, TimeUnit.MINUTES)) == null) {
                            continue;
                        }
                        if (!watchKey.pollEvents().isEmpty()) {
                            this.receivedRawEvent();
                        }
                        watchKey.reset();
                    }
                }
                catch (InterruptedException e) {
                    logger.debug("File watching timed out, restarting watcher.");
                    continue;
                }
                break;
            }
        }, "FileBasedBroker: " + name).start();
    }

    public static FileBasedMessagingBroker connect(String name, File exchangeFile) throws IOException {
        if (createdBrokers.contains(exchangeFile.getAbsolutePath())) {
            throw new IOException(String.format("The file based messaging broker for '%s' was already created!", exchangeFile.getAbsolutePath()));
        }
        FileBasedMessagingBroker broker = new FileBasedMessagingBroker(name, exchangeFile);
        createdBrokers.add(exchangeFile.getAbsolutePath());
        return broker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void receivedRawEvent() {
        ArrayList<MessageListeners> listeners = new ArrayList<MessageListeners>();
        try (RandomAccessFile raFile = new RandomAccessFile(this.file, "rw");){
            FileChannel channel = raFile.getChannel();
            FileLock lock = null;
            try {
                MessageLine line;
                lock = this.obtainFileLock(60000L, channel);
                ArrayList<MessageLine> leftLines = new ArrayList<MessageLine>();
                while ((line = this.readNextLine(raFile)) != null) {
                    List<QueueListener> queListeners = this.getQueueListeners(line.getTopic());
                    if (queListeners != null) {
                        listeners.add(new MessageListeners(line, queListeners));
                        continue;
                    }
                    leftLines.add(line);
                }
                if (!listeners.isEmpty()) {
                    raFile.setLength(0L);
                    if (!leftLines.isEmpty()) {
                        for (MessageLine l : leftLines) {
                            raFile.write(l.toString().getBytes(StandardCharsets.UTF_8));
                        }
                    }
                }
            }
            finally {
                try {
                    if (lock != null) {
                        lock.release();
                    }
                }
                finally {
                    channel.close();
                }
            }
        }
        catch (Exception e) {
            logger.error("Could not read events", (Throwable)e);
        }
        finally {
            listeners.forEach(msg -> msg.getListeners().forEach(listener -> {
                try {
                    listener.received(msg.getMessage().getData(), msg.getMessage().getTopic(), msg.getMessage().getId());
                }
                catch (Throwable th) {
                    logger.error("error in the handler implementation!", th);
                }
            }));
        }
    }

    private MessageLine readNextLine(RandomAccessFile file) throws IOException {
        String line = file.readLine();
        if (line != null) {
            return new MessageLine(line);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<QueueListener> getQueueListeners(String topic) {
        Map<String, List<String>> map = this.subscriptions;
        synchronized (map) {
            ArrayList<QueueListener> result = new ArrayList<QueueListener>();
            this.subscriptions.forEach((tpc, queues) -> {
                String pattern = this.getTopicRegexp((String)tpc);
                if (topic.matches(pattern)) {
                    queues.forEach(queue -> {
                        List<QueueListener> qListeners = this.listeners.get(queue);
                        if (qListeners != null && !qListeners.isEmpty()) {
                            result.addAll((Collection)this.listeners.get(queue));
                        }
                    });
                }
            });
            if (!result.isEmpty()) {
                return result;
            }
        }
        return null;
    }

    private String getTopicRegexp(String eventPattern) {
        Objects.requireNonNull(eventPattern, "the topic pattern must not be null");
        return eventPattern.trim().replace("*", "\\*").replaceAll("/\\\\\\*\\\\\\*$", "/.*").replaceAll("\\\\\\*\\s*/", "([^/]*)/").replaceAll("\\\\\\*$", "([^/]*)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void emitMessage(String topic, String message) {
        try (RandomAccessFile raFile = new RandomAccessFile(this.file, "rw");){
            FileChannel channel = raFile.getChannel();
            FileLock lock = null;
            try {
                lock = this.obtainFileLock(60000L, channel);
                MessageLine line = new MessageLine(topic, message);
                channel.write(ByteBuffer.wrap(line.toString().getBytes(StandardCharsets.UTF_8)), channel.size());
            }
            finally {
                try {
                    if (lock != null) {
                        lock.release();
                    }
                }
                finally {
                    channel.close();
                }
            }
        }
        catch (Exception e) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.EVENT_EMITTING_FAILED, new Object[]{topic, e});
        }
    }

    public void listenToQueue(String queue, QueueListener listener) {
        List<QueueListener> lists;
        if (!this.listeners.containsKey(queue)) {
            this.listeners.put(queue, new ArrayList());
        }
        if (!(lists = this.listeners.get(queue)).contains(listener)) {
            lists.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subscribeTopic(String queue, String topic) {
        Map<String, List<String>> map = this.subscriptions;
        synchronized (map) {
            List<String> queues;
            if (!this.subscriptions.containsKey(topic)) {
                this.subscriptions.put(topic, new ArrayList());
            }
            if (!(queues = this.subscriptions.get(topic)).contains(queue)) {
                queues.add(queue);
            }
        }
    }

    private FileLock obtainFileLock(long timeout, FileChannel channel) throws IOException, InterruptedException, TimeoutException {
        Long quitTime = System.currentTimeMillis() + timeout;
        do {
            try {
                FileLock lock = channel.tryLock();
                if (lock != null) {
                    return lock;
                }
                Thread.sleep(1000L);
            }
            catch (OverlappingFileLockException e) {
                Thread.sleep(1000L);
            }
        } while (System.currentTimeMillis() < quitTime);
        throw new TimeoutException();
    }

    private static class MessageLine {
        private String topic;
        private String id;
        private JSONObject jsonData;
        private String data;

        public MessageLine(String line) throws IOException {
            String message = line.trim();
            int separator = message.indexOf(32);
            if (separator == -1) {
                throw new IOException("Invalid line representation!");
            }
            this.topic = message.substring(0, separator);
            this.data = message.substring(separator).trim();
            this.init(this.topic, this.data);
        }

        private MessageLine(String topic, String data) {
            this.init(topic, data);
        }

        private void init(String topic, String data) {
            this.topic = topic;
            this.data = data;
            this.jsonData = this.asJson(data);
            this.id = this.jsonData != null && this.jsonData.has("id") ? this.jsonData.getString("id") : UUID.randomUUID().toString();
        }

        private JSONObject asJson(String event) {
            try {
                return new JSONObject(event);
            }
            catch (Throwable throwable) {
                return null;
            }
        }

        public String getTopic() {
            return this.topic;
        }

        public String getId() {
            return this.id;
        }

        public String getData() {
            return this.jsonData != null ? this.jsonData.toString() : this.data;
        }

        public String toString() {
            return this.topic + ' ' + this.data.toString() + System.lineSeparator();
        }
    }

    private static class MessageListeners {
        MessageLine message;
        List<QueueListener> listeners;

        public MessageListeners(MessageLine message, List<QueueListener> listeners) {
            this.message = message;
            this.listeners = listeners;
        }

        public MessageLine getMessage() {
            return this.message;
        }

        public List<QueueListener> getListeners() {
            return this.listeners;
        }
    }

    public static interface QueueListener {
        public void received(String var1, String var2, String var3);
    }
}

