/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.persistence;

import com.sap.cds.CdsDataProcessor;
import com.sap.cds.ql.cqn.Path;
import com.sap.cds.reflect.CdsArrayedType;
import com.sap.cds.reflect.CdsBaseType;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.reflect.CdsSimpleType;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.reflect.CdsType;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.EventContext;
import com.sap.cds.services.handler.EventHandler;
import com.sap.cds.services.handler.annotations.Before;
import com.sap.cds.services.handler.annotations.HandlerOrder;
import com.sap.cds.services.handler.annotations.ServiceName;
import com.sap.cds.services.impl.utils.CdsServiceUtils;
import com.sap.cds.services.persistence.PersistenceService;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;

@ServiceName(value={"*"}, type={PersistenceService.class})
public class FieldLengthAssertionHandler
implements EventHandler {
    @Before(event={"CREATE", "UPDATE", "UPSERT"})
    @HandlerOrder(value=11100)
    public void runCheck(EventContext context) {
        CdsDataProcessor.create().addValidator(FieldLengthAssertionHandler::isStringWithLength, FieldLengthAssertionHandler::validateFieldLength).process(CdsServiceUtils.getEntities(context), (CdsStructuredType)context.getTarget());
    }

    private static void validateFieldLength(Path path, CdsElement element, Object value) {
        if (value instanceof String) {
            Integer maxLength = (Integer)FieldLengthAssertionHandler.simpleType(element).get("length");
            int valueLength = ((String)value).length();
            if (valueLength > maxLength) {
                throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.EXCEEDED_FIELD_LENGTH, new Object[]{element.getName(), maxLength}).messageTarget(path, element);
            }
        }
    }

    private static boolean isStringWithLength(Path path, CdsElement element, CdsType t) {
        return t.isSimpleType(CdsBaseType.STRING) && ((CdsSimpleType)t.as(CdsSimpleType.class)).get("length") != null;
    }

    private static CdsSimpleType simpleType(CdsElement element) {
        if (element.getType().isArrayed()) {
            return (CdsSimpleType)((CdsArrayedType)element.getType().as(CdsArrayedType.class)).getItemsType().as(CdsSimpleType.class);
        }
        return (CdsSimpleType)element.getType().as(CdsSimpleType.class);
    }
}

