/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.request;

import com.sap.cds.reflect.CdsModel;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.ServiceCatalog;
import com.sap.cds.services.messages.Messages;
import com.sap.cds.services.request.FeatureTogglesInfo;
import com.sap.cds.services.request.ParameterInfo;
import com.sap.cds.services.request.RequestContext;
import com.sap.cds.services.request.UserInfo;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import java.util.Objects;

public class RequestContextHelper
implements RequestContext {
    private final CdsRuntime runtime;

    RequestContextHelper(CdsRuntime runtime) {
        Objects.requireNonNull(runtime, "runtime must not be null");
        this.runtime = runtime;
    }

    public CdsModel getModel() {
        UserInfo providedUserInfo = this.runtime.getProvidedUserInfo();
        return this.runtime.getCdsModel(providedUserInfo, this.runtime.getFeatureTogglesInfo(providedUserInfo, this.runtime.getProvidedParameterInfo()));
    }

    public ServiceCatalog getServiceCatalog() {
        return this.runtime.getServiceCatalog();
    }

    public ParameterInfo getParameterInfo() {
        return this.runtime.getProvidedParameterInfo();
    }

    public UserInfo getUserInfo() {
        return this.runtime.getProvidedUserInfo();
    }

    public Messages getMessages() {
        throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.TEMPORARY_REQUEST_CONTEXT_MESSAGES, new Object[0]);
    }

    public FeatureTogglesInfo getFeatureTogglesInfo() {
        return this.runtime.getFeatureTogglesInfo(this.runtime.getProvidedUserInfo(), this.runtime.getProvidedParameterInfo());
    }
}

