/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.authorization;

import com.sap.cds.ql.CQL;
import com.sap.cds.ql.Select;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.cqn.CqnSelect;
import com.sap.cds.ql.cqn.CqnStructuredTypeRef;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.EventContext;
import com.sap.cds.services.authorization.ActionAccessEventContext;
import com.sap.cds.services.authorization.AuthorizationService;
import com.sap.cds.services.authorization.CalcWhereConditionEventContext;
import com.sap.cds.services.authorization.EntityAccessEventContext;
import com.sap.cds.services.authorization.FunctionAccessEventContext;
import com.sap.cds.services.authorization.GetRestrictionEventContext;
import com.sap.cds.services.authorization.ServiceAccessEventContext;
import com.sap.cds.services.handler.EventHandler;
import com.sap.cds.services.handler.annotations.HandlerOrder;
import com.sap.cds.services.handler.annotations.On;
import com.sap.cds.services.handler.annotations.ServiceName;
import com.sap.cds.services.impl.authorization.AuthorizationEntity;
import com.sap.cds.services.impl.authorization.PredicateLookup;
import com.sap.cds.services.impl.authorization.PredicateResolver;
import com.sap.cds.services.impl.authorization.RestrictionLookup;
import com.sap.cds.services.impl.authorization.RestrictionUtils;
import com.sap.cds.services.impl.changeset.ChangeSetContextImpl;
import com.sap.cds.services.impl.draft.ParentEntityLookup;
import com.sap.cds.services.impl.utils.CdsServiceUtils;
import com.sap.cds.services.request.RequestContext;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import com.sap.cds.services.utils.StringUtils;
import com.sap.cds.services.utils.TenantAwareCache;
import com.sap.cds.services.utils.model.Privilege;
import com.sap.cds.services.utils.model.Restriction;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ServiceName(value={"*"}, type={AuthorizationService.class})
public class AuthorizationDefaultOnHandler
implements EventHandler {
    private static final Logger logger = LoggerFactory.getLogger(AuthorizationDefaultOnHandler.class);
    private final TenantAwareCache<RestrictionLookup, CdsModel> restrictionLookupCache;
    private final TenantAwareCache<PredicateLookup, CdsModel> predicateLookupCache;
    private final TenantAwareCache<ParentEntityLookup, CdsModel> parentEntityLookups;

    AuthorizationDefaultOnHandler(CdsRuntime runtime) {
        this.restrictionLookupCache = TenantAwareCache.create(() -> new RestrictionLookup(), (CdsRuntime)runtime);
        this.predicateLookupCache = TenantAwareCache.create(() -> new PredicateLookup(), (CdsRuntime)runtime);
        this.parentEntityLookups = TenantAwareCache.create(() -> new ParentEntityLookup(RequestContext.getCurrent((CdsRuntime)runtime).getModel()), (CdsRuntime)runtime);
    }

    @On
    @HandlerOrder(value=11000)
    protected void defaultGetRestriction(GetRestrictionEventContext context) {
        Restriction restriction = null;
        switch (context.getKind()) {
            case SERVICE: {
                restriction = ((RestrictionLookup)this.restrictionLookupCache.findOrCreate()).retrieveServiceRestriction(context.getModel(), context.getName());
                break;
            }
            case ENTITY: {
                restriction = ((RestrictionLookup)this.restrictionLookupCache.findOrCreate()).retrieveEntityRestriction(context.getModel(), context.getName());
                break;
            }
            case ACTION: {
                restriction = ((RestrictionLookup)this.restrictionLookupCache.findOrCreate()).lookupActionRestriction(context.getModel(), context.getName(), context.getEventName());
                break;
            }
            case FUNCTION: {
                restriction = ((RestrictionLookup)this.restrictionLookupCache.findOrCreate()).lookupFunctionRestriction(context.getModel(), context.getName(), context.getEventName());
                break;
            }
            default: {
                throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.UNSUPPORTED_RESTRICTION, new Object[]{context.getName(), context.getKind()});
            }
        }
        context.setResult((Object)restriction);
    }

    @On
    @HandlerOrder(value=11000)
    protected void defaultHasServiceAccess(ServiceAccessEventContext context) {
        String event = context.getAccessEventName();
        String service = context.getAccessServiceName();
        boolean result = true;
        Restriction restriction = RestrictionUtils.getServiceRestriction(context.getService(), service, event);
        if (restriction != null) {
            result = RestrictionUtils.passesRestriction(restriction, context.getUserInfo(), event);
        }
        context.setResult(result);
    }

    @On
    @HandlerOrder(value=11000)
    protected void defaultHasEntityAccess(EntityAccessEventContext context) {
        ChangeSetContextImpl changeSetContext = (ChangeSetContextImpl)context.getChangeSetContext();
        boolean result = changeSetContext == null || !changeSetContext.hasChangeSetMember() ? ((Boolean)context.getCdsRuntime().changeSetContext().run(c -> this.defaultHasEntityAccessImpl(context))).booleanValue() : this.defaultHasEntityAccessImpl(context);
        context.setResult(result);
    }

    protected boolean defaultHasEntityAccessImpl(EntityAccessEventContext context) {
        CqnPredicate authorizationCondition;
        String event = context.getAccessEventName();
        String targetEntityName = context.getAccessEntityName();
        AuthorizationEntity authEntity = AuthorizationEntity.resolve(context, entity -> ((ParentEntityLookup)this.parentEntityLookups.findOrCreate()).lookupParent((CdsEntity)entity));
        if (authEntity.getAuthorizationEntity() == null) {
            logger.debug("No authorization entity found when sending event '{}' to entity '{}'", (Object)event, (Object)targetEntityName);
            return false;
        }
        String authorizationEntityName = authEntity.getAuthorizationEntity().getQualifiedName();
        Restriction restriction = RestrictionUtils.getEntityRestriction(context.getService(), authorizationEntityName, event);
        if (restriction != null && !RestrictionUtils.passesRestriction(restriction, context.getUserInfo(), event)) {
            if (authorizationEntityName.equals(targetEntityName)) {
                logger.debug("No authorization to send event '{}' to entity '{}'", (Object)event, (Object)targetEntityName);
            } else {
                logger.debug("No authorization to send event '{}' to entity '{}' because of authorization entity '{}'", new Object[]{event, targetEntityName, authorizationEntityName});
            }
            return false;
        }
        if (!authorizationEntityName.equals(targetEntityName) && authEntity.getAuthorizationPath() != null && !authEntity.isDraft() && (authorizationCondition = authEntity.authorizationCondition(authEntity.getAuthorizationEntity(), event)) != null) {
            Select readTest = Select.from((CqnStructuredTypeRef)authEntity.getAuthorizationPath()).where(authorizationCondition);
            if (!CdsServiceUtils.getDefaultPersistenceService((EventContext)context).run((CqnSelect)readTest, new Object[0]).first().isPresent()) {
                logger.debug("No authorization to send event '{}' to entity '{}' because of instance '{}'", new Object[]{event, targetEntityName, authEntity.getAuthorizationPath()});
                return false;
            }
        }
        return true;
    }

    @On
    @HandlerOrder(value=11000)
    protected void defaultHasFunctionAccess(FunctionAccessEventContext context) {
        String functionName = context.getFunctionName();
        String entityName = context.getEntityName();
        boolean result = true;
        Restriction restriction = RestrictionUtils.getFunctionRestriction(context.getService(), entityName, functionName);
        if (restriction != null) {
            result = RestrictionUtils.passesRestriction(restriction, context.getUserInfo(), Privilege.PredefinedGrant.ALL.toString());
        }
        context.setResult(result);
    }

    @On
    @HandlerOrder(value=11000)
    protected void defaultHasActionAccess(ActionAccessEventContext context) {
        String actionName = context.getActionName();
        String entityName = context.getEntityName();
        boolean result = true;
        Restriction restriction = RestrictionUtils.getActionRestriction(context.getService(), entityName, actionName);
        if (restriction != null) {
            result = RestrictionUtils.passesRestriction(restriction, context.getUserInfo(), Privilege.PredefinedGrant.ALL.toString());
        }
        context.setResult(result);
    }

    @On
    @HandlerOrder(value=11000)
    protected void defaultCalcWhereCondition(CalcWhereConditionEventContext context) {
        Restriction restriction;
        String event = context.getEventName();
        String entityName = context.getEntityName();
        CqnPredicate result = null;
        if (!context.getUserInfo().isPrivileged() && (restriction = RestrictionUtils.getEntityRestriction(context.getService(), entityName, event)) != null) {
            List privileges = RestrictionUtils.passingPrivilegesOfRestriction(restriction, context.getUserInfo(), event).collect(Collectors.toList());
            for (Privilege privilege : privileges) {
                CqnPredicate cqnPredicate = null;
                if (!StringUtils.isEmpty((String)privilege.getCxnWhereCondition())) {
                    try {
                        cqnPredicate = ((PredicateLookup)this.predicateLookupCache.findOrCreate()).resolvePredicate(privilege.getCxnWhereCondition(), context.getUserInfo());
                    }
                    catch (PredicateResolver.MultipleAttributeValuesNotSupportedException e) {
                        logger.debug("No authorization to send event '{}' to entity '{}' because user {} has multiple values for attribute '{}' (filter resource '{}')", new Object[]{event, entityName, context.getUserInfo().getName(), e.getAttributeName(), e.getResourceName(), e});
                        throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.EVENT_FORBIDDEN_UNSUPPORTED_USER_ATTRIBUTES, new Object[]{event, entityName, e.getAttributeName(), e});
                    }
                    catch (Exception e) {
                        throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.INVALID_WHERE_CONDITION, new Object[]{privilege.getCxnWhereCondition(), entityName, event, context.getUserInfo().getName(), e});
                    }
                } else if (!StringUtils.isEmpty((String)privilege.getWhereCondition())) {
                    throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.INCONSISTENT_WHERE_CONDITION, new Object[]{privilege.getWhereCondition(), entityName});
                }
                if (cqnPredicate == null) {
                    result = null;
                    break;
                }
                result = result != null ? CQL.or((CqnPredicate)result, (CqnPredicate)cqnPredicate) : cqnPredicate;
            }
        }
        context.setResult(result);
    }
}

