/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.authorization;

import com.sap.cds.reflect.CdsKind;
import com.sap.cds.services.EventContext;
import com.sap.cds.services.authorization.AuthorizationService;
import com.sap.cds.services.authorization.GetRestrictionEventContext;
import com.sap.cds.services.impl.utils.CdsModelUtils;
import com.sap.cds.services.request.UserInfo;
import com.sap.cds.services.utils.model.Privilege;
import com.sap.cds.services.utils.model.Restriction;
import java.util.Objects;
import java.util.stream.Stream;

public class RestrictionUtils {
    private RestrictionUtils() {
    }

    public static boolean passesRestriction(Restriction restriction, UserInfo user, String event) {
        return RestrictionUtils.passingPrivilegesOfRestriction(restriction, user, event).findAny().isPresent();
    }

    public static Stream<Privilege> passingPrivilegesOfRestriction(Restriction restriction, UserInfo user, String event) {
        Objects.requireNonNull(restriction, "Restriction required");
        Objects.requireNonNull(user, "UserInfo required");
        Objects.requireNonNull(event, "event required");
        return restriction.privileges().filter(privilege -> RestrictionUtils.hasPrivilege(privilege, user, event));
    }

    public static boolean hasPrivilege(Privilege privilege, UserInfo user, String event) {
        if (privilege == null || user == null || event == null) {
            return false;
        }
        if (user.isPrivileged()) {
            return true;
        }
        boolean matchesGrant = false;
        for (String grant : privilege.getGrants()) {
            if (!Privilege.PredefinedGrant.ALL.is(grant) && !Privilege.is((String)event, (String)grant) && (!Privilege.PredefinedGrant.WRITE.is(grant) || !CdsModelUtils.isWriteEvent(event)) && !CdsModelUtils.eventIsGranted(event, grant)) continue;
            matchesGrant = true;
            break;
        }
        if (!matchesGrant) {
            return false;
        }
        assert (matchesGrant);
        if (privilege.getRoles().isEmpty()) {
            return true;
        }
        boolean matchesRole = false;
        for (String role : privilege.getRoles()) {
            if (Privilege.PredefinedRole.ANY_USER.is(role)) {
                matchesRole = true;
            } else if (Privilege.PredefinedRole.AUTHENTICATED_USER.is(role)) {
                matchesRole = user.isAuthenticated();
            } else if (Privilege.PredefinedRole.SYSTEM_USER.is(role)) {
                matchesRole = user.isSystemUser();
            } else if (user.hasRole(role)) {
                boolean bl = matchesRole = user.isAuthenticated() || user.isSystemUser();
            }
            if (!matchesRole) continue;
            break;
        }
        return matchesRole;
    }

    static Restriction getEntityRestriction(AuthorizationService service, String entityName, String event) {
        GetRestrictionEventContext context = GetRestrictionEventContext.create();
        context.setName(entityName);
        context.setKind(CdsKind.ENTITY);
        context.setEventName(event);
        service.emit((EventContext)context);
        return (Restriction)context.getResult();
    }

    static Restriction getServiceRestriction(AuthorizationService service, String serviceName, String event) {
        GetRestrictionEventContext context = GetRestrictionEventContext.create();
        context.setName(serviceName);
        context.setKind(CdsKind.SERVICE);
        context.setEventName(event);
        service.emit((EventContext)context);
        return (Restriction)context.getResult();
    }

    static Restriction getFunctionRestriction(AuthorizationService service, String entityName, String functionName) {
        GetRestrictionEventContext context = GetRestrictionEventContext.create();
        context.setName(entityName);
        context.setKind(CdsKind.FUNCTION);
        context.setEventName(functionName);
        service.emit((EventContext)context);
        return (Restriction)context.getResult();
    }

    static Restriction getActionRestriction(AuthorizationService service, String entityName, String actionName) {
        GetRestrictionEventContext context = GetRestrictionEventContext.create();
        context.setName(entityName);
        context.setKind(CdsKind.ACTION);
        context.setEventName(actionName);
        service.emit((EventContext)context);
        return (Restriction)context.getResult();
    }
}

