/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.cds;

import com.sap.cds.impl.parser.StructDataParser;
import com.sap.cds.reflect.CdsEvent;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.EventContext;
import com.sap.cds.services.cds.RemoteService;
import com.sap.cds.services.environment.CdsProperties;
import com.sap.cds.services.handler.Handler;
import com.sap.cds.services.impl.cds.AbstractCdsDefinedService;
import com.sap.cds.services.impl.messaging.message.CdsMessagingUtils;
import com.sap.cds.services.messaging.CloudEventMessageEventContext;
import com.sap.cds.services.messaging.MessagingService;
import com.sap.cds.services.messaging.TopicMessageEventContext;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import com.sap.cds.services.utils.StringUtils;
import com.sap.cds.services.utils.messaging.CloudEventUtils;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteServiceImpl
extends AbstractCdsDefinedService
implements RemoteService {
    private static final Logger logger = LoggerFactory.getLogger(RemoteServiceImpl.class);
    private final Set<String> declaredEventsWithOnHandlers = ConcurrentHashMap.newKeySet();

    public RemoteServiceImpl(CdsProperties.Remote.RemoteServiceConfig config, CdsRuntime runtime) {
        super(config.getName(), config.getModel(), runtime);
    }

    public void on(String[] events, String[] entities, int order, Handler handler) {
        super.on(events, entities, order, handler);
        this.checkEvents(events);
    }

    private void checkEvents(String[] events) {
        MessagingService messagingService = CdsMessagingUtils.getMessagingService(this.runtime);
        if (messagingService != null) {
            Arrays.stream(events).filter(event -> !StringUtils.isEmpty((String)event) && !event.equals("*")).forEach(event -> {
                CdsEvent declaredEvent = this.getDefinition().events().filter(e -> e.getName().equals(event)).findFirst().orElse(null);
                if (declaredEvent != null && this.declaredEventsWithOnHandlers.add(declaredEvent.getQualifiedName())) {
                    String topic = CdsMessagingUtils.getTopic(declaredEvent);
                    logger.debug("Registering inbound event handler for declared event '{}' with topic '{}' on messaging service '{}' targeting remote service '{}'", new Object[]{declaredEvent.getQualifiedName(), topic, messagingService.getName(), this.getName()});
                    messagingService.on(topic, null, context -> {
                        CloudEventMessageEventContext cloudContext = CloudEventUtils.toCloudEventMessageContext((TopicMessageEventContext)((TopicMessageEventContext)context.as(TopicMessageEventContext.class)), (String)declaredEvent.getName());
                        this.mapDataTypes(declaredEvent, cloudContext);
                        this.emit((EventContext)cloudContext);
                    });
                }
            });
        }
    }

    private void mapDataTypes(CdsEvent event, CloudEventMessageEventContext context) {
        try {
            String jsonData = CloudEventUtils.toJson((Map)context.getData());
            context.setData(StructDataParser.create((CdsStructuredType)event).parseObject(jsonData));
        }
        catch (Exception e) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.INVALID_DATA_FORMAT, new Object[]{event.getQualifiedName(), e});
        }
    }
}

