/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.draft;

import com.sap.cds.impl.parser.builder.ExpressionBuilder;
import com.sap.cds.impl.parser.token.RefSegmentImpl;
import com.sap.cds.ql.CQL;
import com.sap.cds.ql.Delete;
import com.sap.cds.ql.ElementRef;
import com.sap.cds.ql.Predicate;
import com.sap.cds.ql.RefSegment;
import com.sap.cds.ql.Select;
import com.sap.cds.ql.StructuredTypeRef;
import com.sap.cds.ql.Value;
import com.sap.cds.ql.cqn.AnalysisResult;
import com.sap.cds.ql.cqn.CqnComparisonPredicate;
import com.sap.cds.ql.cqn.CqnConnectivePredicate;
import com.sap.cds.ql.cqn.CqnDelete;
import com.sap.cds.ql.cqn.CqnModifier;
import com.sap.cds.ql.cqn.CqnNegation;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.cqn.CqnReference;
import com.sap.cds.ql.cqn.CqnSelect;
import com.sap.cds.ql.cqn.CqnStatement;
import com.sap.cds.ql.cqn.CqnStructuredTypeRef;
import com.sap.cds.ql.cqn.CqnValue;
import com.sap.cds.ql.cqn.Modifier;
import com.sap.cds.ql.impl.Xpr;
import com.sap.cds.reflect.CdsAnnotatable;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.services.EventContext;
import com.sap.cds.services.impl.draft.ColumnsModifier;
import com.sap.cds.services.impl.draft.DraftModifier;
import com.sap.cds.services.impl.draft.ReferenceModifier;
import com.sap.cds.services.impl.utils.CdsModelUtils;
import com.sap.cds.services.utils.DraftUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CqnAdapter {
    public static final String DRAFT_SUFFIX = "_drafts";

    public static String getDraftsEntity(String entity) {
        if (entity.endsWith(DRAFT_SUFFIX)) {
            return entity;
        }
        return entity + DRAFT_SUFFIX;
    }

    public static List<CqnDelete> adaptActiveEntity(CqnDelete delete, EventContext context) {
        return CqnAdapter.adapt(delete, context, true);
    }

    public static <T extends CqnStatement> List<T> adapt(T stmt, EventContext context) {
        return CqnAdapter.adapt(stmt, context, false);
    }

    private static <T extends CqnStatement> List<T> adapt(T stmt, EventContext context, boolean modifyIsActiveOnly) {
        AnalysisResult entityPath = CdsModelUtils.getEntityPath(stmt, context.getModel());
        if (stmt.isSelect() && stmt.asSelect().where().isPresent() && context.getCdsRuntime().getEnvironment().getCdsProperties().getDrafts().getAssociationsToInactiveEntities().isEnabled().booleanValue()) {
            ((Select)stmt).where(CqnAdapter.addDraftAssociations((CqnPredicate)stmt.asSelect().where().get(), entityPath.targetEntity()));
        }
        List<List<Boolean>> followActiveAssociations = ReferenceModifier.getAssociationDirections(stmt, context);
        boolean addSecurityConstraints = stmt.isSelect();
        ArrayList<CqnStatement> result = new ArrayList<CqnStatement>(followActiveAssociations.size());
        for (List<Boolean> followActive : followActiveAssociations) {
            ReferenceModifier modifier = new ReferenceModifier(entityPath.rootEntity(), modifyIsActiveOnly, followActive, addSecurityConstraints, context, !stmt.isInsert() && !stmt.isSelect());
            CqnStatement toAdd = CQL.copy(stmt, (Modifier)modifier);
            AnalysisResult adaptedEntityPath = CdsModelUtils.getEntityPath(toAdd, context.getModel());
            if (stmt.isSelect()) {
                toAdd = CQL.copy((CqnStatement)toAdd, (Modifier)new ColumnsModifier(adaptedEntityPath.targetEntity(), context));
            }
            if (!stmt.isInsert()) {
                toAdd = CQL.copy((CqnStatement)toAdd, (Modifier)new DraftModifier(adaptedEntityPath.targetEntity(), !stmt.isSelect(), context));
            }
            result.add(toAdd);
        }
        return result;
    }

    public static Delete<?> toDelete(CqnSelect s) {
        Delete delete = Delete.from((CqnStructuredTypeRef)s.ref());
        s.where().ifPresent(arg_0 -> ((Delete)delete).where(arg_0));
        return delete;
    }

    public static Select<?> toSelect(CqnDelete delete) {
        Select select = Select.from((CqnStructuredTypeRef)delete.ref());
        delete.where().ifPresent(arg_0 -> ((Select)select).where(arg_0));
        return select;
    }

    private static CqnPredicate addDraftAssociations(CqnPredicate predicate, CdsEntity entity) {
        CqnPredicate result = predicate;
        if (predicate instanceof CqnConnectivePredicate) {
            CqnConnectivePredicate connective = (CqnConnectivePredicate)predicate;
            ArrayList<CqnPredicate> predicates = new ArrayList<CqnPredicate>(connective.predicates());
            for (int i = 0; i < predicates.size(); ++i) {
                CqnPredicate replacement = CqnAdapter.addDraftAssociations((CqnPredicate)predicates.get(i), entity);
                predicates.remove(i);
                predicates.add(i, replacement);
            }
            result = CQL.connect((CqnConnectivePredicate.Operator)connective.operator(), predicates);
        } else if (predicate instanceof CqnComparisonPredicate) {
            CqnComparisonPredicate compPred = (CqnComparisonPredicate)predicate;
            List<CqnValue> leftValues = compPred.left() instanceof ElementRef ? CqnAdapter.resolveDraftAssociations((ElementRef)compPred.left(), entity) : Collections.singletonList(compPred.left());
            List<CqnValue> rightValues = compPred.right() instanceof ElementRef ? CqnAdapter.resolveDraftAssociations((ElementRef)compPred.right(), entity) : Collections.singletonList(compPred.right());
            ArrayList<Predicate> newPredicates = new ArrayList<Predicate>(leftValues.size() * rightValues.size());
            CqnComparisonPredicate.Operator operator = compPred.operator();
            for (CqnValue leftValue : leftValues) {
                for (CqnValue rightValue : rightValues) {
                    newPredicates.add(CQL.comparison((CqnValue)leftValue, (CqnComparisonPredicate.Operator)operator, (CqnValue)rightValue));
                }
            }
            result = CQL.or(newPredicates);
        } else if (predicate instanceof CqnNegation) {
            CqnNegation negation = (CqnNegation)predicate;
            result = CQL.not((CqnPredicate)CqnAdapter.addDraftAssociations(negation.predicate(), entity));
        } else if (predicate instanceof Xpr) {
            Xpr plainPredicate = (Xpr)predicate;
            List tokens = plainPredicate.xpr();
            CqnValue val = (CqnValue)tokens.remove(0);
            List<CqnValue> newValues = val instanceof ElementRef ? CqnAdapter.resolveDraftAssociations((ElementRef)val, entity) : Collections.singletonList(val);
            ArrayList<Predicate> newPredicates = new ArrayList<Predicate>(newValues.size());
            for (CqnValue value : newValues) {
                ArrayList<CqnValue> p = new ArrayList<CqnValue>(tokens);
                p.add(0, value);
                newPredicates.add(ExpressionBuilder.create(p).predicate());
            }
            result = CQL.or(newPredicates);
        }
        return result;
    }

    private static List<CqnValue> resolveDraftAssociations(ElementRef<?> ref, CdsEntity entity) {
        ArrayList<RefSegment> segments = new ArrayList<RefSegment>(ref.segments());
        ArrayList<List<RefSegment>> allPaths = new ArrayList<List<RefSegment>>();
        allPaths.add(segments);
        CqnAdapter.resolveDraftAssociations(segments, allPaths, 0, entity);
        ArrayList<CqnValue> result = new ArrayList<CqnValue>();
        for (List list : allPaths) {
            result.add((CqnValue)CQL.get((List)list));
        }
        return result;
    }

    private static void resolveDraftAssociations(List<RefSegment> segments, List<List<RefSegment>> allPaths, int j, CdsEntity entity) {
        CdsEntity targetEntity = entity;
        for (int i = j; i < segments.size(); ++i) {
            String id = segments.get(i).id();
            if (!targetEntity.findAssociation(id).isPresent()) continue;
            String draftAssociation = id + DRAFT_SUFFIX;
            boolean draftAssociationFound = targetEntity.findAssociation(draftAssociation).isPresent();
            if (!DraftUtils.isDraftEnabled((CdsAnnotatable)(targetEntity = targetEntity.getTargetOf(id))) || !draftAssociationFound) continue;
            ArrayList<RefSegment> newSegments = new ArrayList<RefSegment>(segments);
            RefSegment segment = RefSegmentImpl.copy((CqnReference.Segment)((CqnReference.Segment)newSegments.remove(i)));
            segment.id(draftAssociation);
            newSegments.add(i, segment);
            allPaths.add(newSegments);
            CqnAdapter.resolveDraftAssociations(newSegments, allPaths, i, targetEntity);
        }
    }

    public static CqnPredicate getSecurityConstraints(EventContext context) {
        if (!context.getCdsRuntime().getEnvironment().getCdsProperties().getSecurity().getDraftProtection().isEnabled().booleanValue()) {
            return null;
        }
        if (context.getUserInfo().isPrivileged()) {
            return null;
        }
        return (CqnPredicate)Select.from((String)"").where(c -> c.exists(outer -> Select.from((String)"DRAFT.DraftAdministrativeData").where(e -> e.get("DraftUUID").eq((Value)outer.get("DraftAdministrativeData_DraftUUID")).and((CqnPredicate)CQL.or((CqnPredicate)e.get("CreatedByUser").isNull(), (CqnPredicate)CQL.or((CqnPredicate)e.get("CreatedByUser").eq((Object)context.getUserInfo().getId()), (CqnPredicate)e.get("CreatedByUser").eq((Object)context.getUserInfo().getName()))), new CqnPredicate[0])))).where().get();
    }

    public static CqnDelete replaceIsActiveEntity(CqnDelete delete, final boolean value) {
        return (CqnDelete)CQL.copy((CqnStatement)delete, (Modifier)new CqnModifier(){

            public CqnStructuredTypeRef ref(StructuredTypeRef ref) {
                ref.segments().forEach(s -> s.filter().ifPresent(f -> s.filter((CqnPredicate)CQL.copy((CqnPredicate)f, (Modifier)this))));
                return ref;
            }

            public Value<?> ref(ElementRef<?> ref) {
                if ("IsActiveEntity".equals(ref.lastSegment())) {
                    return CQL.val((Object)value);
                }
                return super.ref(ref);
            }
        });
    }
}

