/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.handlerregistry.resolver;

import com.google.common.collect.Sets;
import com.sap.cds.CdsData;
import com.sap.cds.Result;
import com.sap.cds.ql.CdsName;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.EventContext;
import com.sap.cds.services.cds.CdsCreateEventContext;
import com.sap.cds.services.cds.CdsDeleteEventContext;
import com.sap.cds.services.cds.CdsReadEventContext;
import com.sap.cds.services.cds.CdsUpdateEventContext;
import com.sap.cds.services.cds.CdsUpsertEventContext;
import com.sap.cds.services.draft.DraftCancelEventContext;
import com.sap.cds.services.draft.DraftCreateEventContext;
import com.sap.cds.services.draft.DraftEditEventContext;
import com.sap.cds.services.draft.DraftNewEventContext;
import com.sap.cds.services.draft.DraftPatchEventContext;
import com.sap.cds.services.draft.DraftPrepareEventContext;
import com.sap.cds.services.draft.DraftSaveEventContext;
import com.sap.cds.services.impl.handlerregistry.AnnotationDescriptor;
import com.sap.cds.services.impl.handlerregistry.HandlerDescriptor;
import com.sap.cds.services.impl.handlerregistry.resolver.ArgumentResolver;
import com.sap.cds.services.impl.utils.ReflectionUtils;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import com.sap.cds.services.utils.ResultUtils;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PojoArgumentResolver
implements ArgumentResolver {
    private static final Logger logger = LoggerFactory.getLogger(PojoArgumentResolver.class);
    private static final Set<String> allowedEvents = Sets.newHashSet((Object[])new String[]{"READ", "CREATE", "UPDATE", "DELETE", "UPSERT", "draftEdit", "draftPrepare", "draftActivate", "DRAFT_NEW", "DRAFT_PATCH", "DRAFT_CANCEL", "DRAFT_CREATE"});
    private static final HashMap<Type, PojoArgumentResolver> cache = new HashMap();
    private final Class<?> pojoClass;
    private final boolean stream;
    private final boolean list;
    private final Type genericType;

    public static PojoArgumentResolver createIfApplicable(Class<?> clazz, Type genericType) {
        PojoArgumentResolver cached = cache.get(genericType);
        if (cached != null) {
            return cached;
        }
        try {
            Class<?> pojoClass;
            ParameterizedType collectionType;
            if (PojoArgumentResolver.isPojoClass(clazz)) {
                return new PojoArgumentResolver(clazz, genericType, false, false);
            }
            boolean stream = Stream.class.isAssignableFrom(clazz);
            boolean list = List.class.isAssignableFrom(clazz);
            if ((stream || list) && (collectionType = ReflectionUtils.getParameterizedType(genericType)).getActualTypeArguments().length == 1 && PojoArgumentResolver.isPojoClass(pojoClass = ReflectionUtils.getClassForType(collectionType.getActualTypeArguments()[0]))) {
                return new PojoArgumentResolver(pojoClass, genericType, stream, list);
            }
        }
        catch (ClassNotFoundException | IllegalArgumentException e) {
            logger.debug("Could not resolve generic type '{}'", (Object)genericType.getTypeName(), (Object)e);
        }
        return null;
    }

    private static boolean isPojoClass(Class<?> pojoClass) throws ClassNotFoundException {
        return CdsData.class.isAssignableFrom(pojoClass);
    }

    private PojoArgumentResolver(Class<?> pojoClass, Type genericType, boolean stream, boolean list) {
        this.pojoClass = pojoClass;
        this.stream = stream;
        this.list = list;
        this.genericType = genericType;
        cache.put(genericType, this);
    }

    @Override
    public Object resolve(EventContext context) {
        if (context.isCompleted()) {
            switch (context.getEvent()) {
                case "READ": {
                    return this.convert(((CdsReadEventContext)context.as(CdsReadEventContext.class)).getResult());
                }
                case "CREATE": {
                    return this.convert(((CdsCreateEventContext)context.as(CdsCreateEventContext.class)).getResult());
                }
                case "UPDATE": {
                    return this.convert(((CdsUpdateEventContext)context.as(CdsUpdateEventContext.class)).getResult());
                }
                case "DELETE": {
                    return this.convert(((CdsDeleteEventContext)context.as(CdsDeleteEventContext.class)).getResult());
                }
                case "UPSERT": {
                    return this.convert(((CdsUpsertEventContext)context.as(CdsUpsertEventContext.class)).getResult());
                }
                case "DRAFT_NEW": {
                    return this.convert(((DraftNewEventContext)context.as(DraftNewEventContext.class)).getResult());
                }
                case "draftEdit": {
                    return this.convert(((DraftEditEventContext)context.as(DraftEditEventContext.class)).getResult());
                }
                case "DRAFT_PATCH": {
                    return this.convert(((DraftPatchEventContext)context.as(DraftPatchEventContext.class)).getResult());
                }
                case "draftPrepare": {
                    return this.convert(((DraftPrepareEventContext)context.as(DraftPrepareEventContext.class)).getResult());
                }
                case "draftActivate": {
                    return this.convert(((DraftSaveEventContext)context.as(DraftSaveEventContext.class)).getResult());
                }
                case "DRAFT_CANCEL": {
                    return this.convert(((DraftCancelEventContext)context.as(DraftCancelEventContext.class)).getResult());
                }
                case "DRAFT_CREATE": {
                    return this.convert(((DraftCreateEventContext)context.as(DraftCreateEventContext.class)).getResult());
                }
            }
            return null;
        }
        switch (context.getEvent()) {
            case "CREATE": {
                return this.convert(ResultUtils.convert((Iterable)((CdsCreateEventContext)context.as(CdsCreateEventContext.class)).getCqn().entries()));
            }
            case "UPDATE": {
                return this.convert(ResultUtils.convert((Iterable)((CdsUpdateEventContext)context.as(CdsUpdateEventContext.class)).getCqn().entries()));
            }
            case "UPSERT": {
                return this.convert(ResultUtils.convert((Iterable)((CdsUpsertEventContext)context.as(CdsUpsertEventContext.class)).getCqn().entries()));
            }
            case "DRAFT_NEW": {
                return this.convert(ResultUtils.convert((Iterable)((DraftNewEventContext)context.as(DraftNewEventContext.class)).getCqn().entries()));
            }
            case "DRAFT_PATCH": {
                return this.convert(ResultUtils.convert((Iterable)((DraftPatchEventContext)context.as(DraftPatchEventContext.class)).getCqn().entries()));
            }
            case "DRAFT_CREATE": {
                return this.convert(ResultUtils.convert((Iterable)((DraftCreateEventContext)context.as(DraftCreateEventContext.class)).getCqn().entries()));
            }
        }
        return null;
    }

    private Object convert(Result result) {
        if (this.stream) {
            return result.streamOf(this.pojoClass);
        }
        if (this.list) {
            return result.listOf(this.pojoClass);
        }
        return result.single(this.pojoClass);
    }

    @Override
    public void verifyOrThrow(HandlerDescriptor descriptor) {
        HashSet<String> events = new HashSet<String>();
        for (AnnotationDescriptor ad : descriptor.getAnnotations()) {
            events.addAll(Arrays.asList(ad.getEvents()));
        }
        for (String event : events) {
            this.verifyEventOrThrow(event, descriptor);
        }
    }

    private void verifyEventOrThrow(String event, HandlerDescriptor descriptor) {
        if (!allowedEvents.contains(event)) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.POJO_ARGUMENT_MISMATCH, new Object[]{event, this.genericType.getTypeName(), descriptor.getMethodName()});
        }
    }

    @Override
    public String[] indicateEntities() {
        CdsName cdsName = this.pojoClass.getAnnotation(CdsName.class);
        if (cdsName != null) {
            return new String[]{cdsName.value()};
        }
        return new String[0];
    }
}

