/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.messaging.file;

import com.sap.cds.services.environment.CdsProperties;
import com.sap.cds.services.impl.messaging.file.FileBasedMessagingBroker;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.utils.messaging.service.AbstractMessagingService;
import com.sap.cds.services.utils.messaging.service.MessagingBrokerQueueListener;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileBasedMessagingService
extends AbstractMessagingService {
    public static final String FILE_KIND = "file-based-messaging";
    private static final Logger logger = LoggerFactory.getLogger(FileBasedMessagingService.class);
    private final FileBasedMessagingBroker broker;

    public FileBasedMessagingService(CdsProperties.Messaging.MessagingServiceConfig serviceConfig, CdsRuntime runtime) throws IOException {
        super(serviceConfig, runtime);
        File file;
        if (serviceConfig.getBinding() == null) {
            file = File.createTempFile("messagexchange", ".txt");
        } else {
            file = new File(serviceConfig.getBinding());
            if (!file.exists() && !file.createNewFile()) {
                throw new IOException("The specified file '" + file.getAbsolutePath() + "' for the file based messaging service could not be created.");
            }
        }
        logger.info("Using '{}' for file-based message exchange", (Object)file.getAbsolutePath());
        this.broker = FileBasedMessagingBroker.connect(this.getName(), file);
    }

    protected void removeQueue(String name) {
    }

    protected void createQueue(String name, Map<String, String> properties) {
    }

    protected void createQueueSubscription(String queue, String topic) {
        this.broker.subscribeTopic(topic);
    }

    protected void registerQueueListener(String queue, MessagingBrokerQueueListener listener) {
        this.broker.registerListener(listener);
    }

    protected void emitTopicMessage(String topic, String message) {
        this.broker.emitMessage(topic, message);
    }
}

