/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.outbox;

import com.sap.cds.services.EventContext;
import com.sap.cds.services.changeset.ChangeSetContext;
import com.sap.cds.services.changeset.ChangeSetListener;
import com.sap.cds.services.outbox.OutboxMessageEventContext;
import com.sap.cds.services.utils.ErrorStatusException;
import com.sap.cds.services.utils.outbox.AbstractOutboxService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemoryOutbox
extends AbstractOutboxService {
    private static final Logger logger = LoggerFactory.getLogger(InMemoryOutbox.class);

    public InMemoryOutbox(String name) {
        super(name);
    }

    protected void enroll(final OutboxMessageEventContext context) {
        logger.debug("Enrolling outbox message with target event '{}'", (Object)context.getEvent());
        final boolean emitDuringChangeSetContext = context.getCdsRuntime().getEnvironment().getCdsProperties().getOutbox().getInMemory().isEmitDuringChangeSetContext();
        final ChangeSetContext changeSet = context.getChangeSetContext();
        changeSet.register(new ChangeSetListener(){

            public void beforeClose() {
                if (!changeSet.isMarkedForCancel() && emitDuringChangeSetContext) {
                    InMemoryOutbox.this.publishMessage(context);
                }
            }

            public void afterClose(boolean completed) {
                if (!emitDuringChangeSetContext && completed) {
                    InMemoryOutbox.this.publishMessage(context);
                }
            }
        });
    }

    private void publishMessage(OutboxMessageEventContext enrollContext) throws ErrorStatusException {
        logger.debug("Publishing outbox message with target event '{}'", (Object)enrollContext.getEvent());
        OutboxMessageEventContext publishContext = OutboxMessageEventContext.create((String)enrollContext.getEvent());
        publishContext.setIsInbound(true);
        publishContext.setTimestamp(enrollContext.getTimestamp());
        publishContext.setMessage(enrollContext.getMessage());
        enrollContext.getService().emit((EventContext)publishContext);
    }
}

