/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.persistence;

import com.sap.cds.reflect.CdsAnnotatable;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.EventContext;
import com.sap.cds.services.handler.EventHandler;
import com.sap.cds.services.handler.annotations.Before;
import com.sap.cds.services.handler.annotations.HandlerOrder;
import com.sap.cds.services.handler.annotations.ServiceName;
import com.sap.cds.services.impl.utils.ValidatorUtils;
import com.sap.cds.services.persistence.PersistenceService;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import com.sap.cds.services.utils.model.CdsAnnotations;
import java.util.Objects;
import java.util.function.Predicate;

@ServiceName(value={"*"}, type={PersistenceService.class})
public class NotNullHandler
implements EventHandler {
    protected static Predicate<CdsElement> requiresNotNullCheck() {
        return element -> {
            if (!ValidatorUtils.requiresNotNullCheck(element)) {
                return false;
            }
            if (!element.isNotNull() || !CdsAnnotations.ASSERT_NOTNULL.isTrue((CdsAnnotatable)element)) {
                return false;
            }
            return CdsAnnotations.ODATA_FOREIGN_KEY_FOR.getOrValue((CdsAnnotatable)element, null) == null;
        };
    }

    @Before(event={"CREATE", "UPDATE", "UPSERT"})
    @HandlerOrder(value=11100)
    public void runCheck(EventContext context) {
        ValidatorUtils.runNotNullCheck(context, NotNullHandler.requiresNotNullCheck(), ValidatorUtils.assertNotNull(context, Objects::isNull, (path, element, entity) -> {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.VALUE_REQUIRED, new Object[]{element.getName(), entity}).messageTarget(path, element);
        }));
    }
}

