/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.runtime;

import com.sap.cds.services.changeset.ChangeSetContext;
import com.sap.cds.services.impl.changeset.ChangeSetContextImpl;
import com.sap.cds.services.impl.runtime.CdsRuntimeImpl;
import com.sap.cds.services.runtime.ChangeSetContextRunner;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangeSetContextRunnerImpl
implements ChangeSetContextRunner {
    private static final Logger logger = LoggerFactory.getLogger(CdsRuntimeImpl.class);

    public <T> T run(Function<ChangeSetContext, T> changeSetHandler) {
        Throwable throwable = null;
        try (ChangeSetContextImpl changeSetContext = ChangeSetContextImpl.open();){
            T t = changeSetHandler.apply((ChangeSetContext)changeSetContext);
            return t;
        }
        catch (Exception e) {
            try {
                changeSetContext.markForCancel();
                logger.info("Exception marked the ChangeSet {} as cancelled: {}", (Object)changeSetContext.getId(), (Object)e.getMessage());
                throw e;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public void run(Consumer<ChangeSetContext> changeSetHandler) {
        this.run((ChangeSetContext changeSetContext) -> {
            changeSetHandler.accept((ChangeSetContext)changeSetContext);
            return Void.TYPE;
        });
    }
}

