/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.runtime;

import com.sap.cds.reflect.CdsModel;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.ServiceCatalog;
import com.sap.cds.services.impl.messages.MessagesImpl;
import com.sap.cds.services.impl.request.ParameterInfoFactory;
import com.sap.cds.services.impl.request.RequestContextImpl;
import com.sap.cds.services.impl.request.RequestContextSPI;
import com.sap.cds.services.impl.request.UserInfoFactory;
import com.sap.cds.services.request.FeatureToggle;
import com.sap.cds.services.request.FeatureTogglesInfo;
import com.sap.cds.services.request.ModifiableParameterInfo;
import com.sap.cds.services.request.ModifiableUserInfo;
import com.sap.cds.services.request.ParameterInfo;
import com.sap.cds.services.request.RequestContext;
import com.sap.cds.services.request.UserInfo;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.runtime.RequestContextRunner;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.CorrelationIdUtils;
import com.sap.cds.services.utils.ErrorStatusException;
import com.sap.cds.services.utils.TenantIdUtils;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;

public class RequestContextRunnerImpl
implements RequestContextRunner {
    private final CdsRuntime cdsRuntime;
    private final RequestContextSPI currentRequestContext;
    private UserInfo userInfo;
    private ParameterInfo parameterInfo;
    private FeatureTogglesInfo featureTogglesInfo;
    private boolean clearMessages = false;

    public RequestContextRunnerImpl(CdsRuntime cdsRuntime) {
        this.cdsRuntime = Objects.requireNonNull(cdsRuntime, "cdsRuntime must not be null");
        this.currentRequestContext = RequestContextImpl.getCurrentInternal();
        if (this.currentRequestContext != null) {
            this.userInfo = this.currentRequestContext.getUserInfo();
            this.parameterInfo = this.currentRequestContext.getParameterInfo();
            this.featureTogglesInfo = this.currentRequestContext.getFeatureTogglesInfo();
        } else {
            this.userInfo = this.providedUserInfo();
            this.parameterInfo = this.providedParameterInfo();
            this.featureTogglesInfo = this.calculateFeatureTogglesInfo();
        }
        assert (this.userInfo != null);
        assert (this.parameterInfo != null);
        assert (this.featureTogglesInfo != null);
    }

    public RequestContextRunner user(UserInfo userInfo) {
        Objects.requireNonNull(userInfo, "userInfo must not be null");
        this.userInfo = userInfo;
        return this;
    }

    public RequestContextRunner anonymousUser() {
        this.userInfo = UserInfoFactory.anonymousUserInfo();
        return this;
    }

    public RequestContextRunner providedUser() {
        this.userInfo = this.providedUserInfo();
        return this;
    }

    public RequestContextRunner privilegedUser() {
        String tenant = this.userInfo.getTenant();
        Map additionalAttributes = this.userInfo.getAdditionalAttributes();
        this.userInfo = UserInfoFactory.privilegedUserInfo();
        this.modifyUser(u -> u.setTenant(tenant).setAdditionalAttributes(additionalAttributes));
        return this;
    }

    public RequestContextRunner modifyUser(Consumer<ModifiableUserInfo> contextUser) {
        UserInfo prevUserInfo = this.userInfo;
        ModifiableUserInfo modifiedUser = prevUserInfo.copy();
        if (contextUser != null) {
            contextUser.accept(modifiedUser);
        }
        this.userInfo = modifiedUser;
        return this;
    }

    public RequestContextRunner parameters(ParameterInfo parameterInfo) {
        Objects.requireNonNull(parameterInfo, "parameterInfo must not be null");
        this.parameterInfo = parameterInfo;
        return this;
    }

    public RequestContextRunner featureToggles(FeatureTogglesInfo featureTogglesInfo) {
        Objects.requireNonNull(featureTogglesInfo, "featureTogglesInfo must not be null");
        this.featureTogglesInfo = featureTogglesInfo;
        return this;
    }

    public RequestContextRunner clearParameters() {
        this.parameterInfo = ParameterInfoFactory.emptyParameterInfo();
        return this;
    }

    public RequestContextRunner providedParameters() {
        this.parameterInfo = this.providedParameterInfo();
        return this;
    }

    public RequestContextRunner modifyParameters(Consumer<ModifiableParameterInfo> contextParamters) {
        ParameterInfo prevParameterInfo = this.parameterInfo;
        ModifiableParameterInfo modifiedParameter = prevParameterInfo.copy();
        if (contextParamters != null) {
            contextParamters.accept(modifiedParameter);
        }
        this.parameterInfo = modifiedParameter;
        return this;
    }

    public RequestContextRunner clearMessages() {
        this.clearMessages = true;
        return this;
    }

    public void run(Consumer<RequestContext> requestHandler) {
        this.run((RequestContext requestContext) -> {
            requestHandler.accept((RequestContext)requestContext);
            return Void.TYPE;
        });
    }

    /*
     * Loose catch block
     */
    public <T> T run(Function<RequestContext, T> requestHandler) {
        T t;
        Throwable throwable;
        RequestContextSPI requestContext;
        String prevTenant;
        boolean putInMDC;
        boolean putTenantInMDC;
        block28: {
            ServiceCatalog serviceCatalog = this.cdsRuntime.getServiceCatalog();
            CdsModel cdsModel = this.cdsRuntime.getCdsModel(this.userInfo, this.featureTogglesInfo);
            Object messages = !this.clearMessages && this.currentRequestContext != null ? this.currentRequestContext.getMessages() : new MessagesImpl(this.cdsRuntime, this.parameterInfo.getLocale());
            putTenantInMDC = !TenantIdUtils.mdcHasEntry();
            putInMDC = !CorrelationIdUtils.mdcHasEntry();
            prevTenant = null;
            requestContext = RequestContextImpl.open(cdsModel, serviceCatalog, this.userInfo, this.parameterInfo, this.featureTogglesInfo, messages);
            throwable = null;
            String correlationId = this.parameterInfo.getCorrelationId();
            if (putInMDC) {
                CorrelationIdUtils.putInMDC((String)correlationId);
            } else if (!CorrelationIdUtils.getFromMDC().equals(correlationId)) {
                throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.MULTIPLE_CORRELATION_IDS, new Object[]{CorrelationIdUtils.getFromMDC(), correlationId});
            }
            String tenantId = this.userInfo.getTenant();
            if (putTenantInMDC) {
                TenantIdUtils.putInMDC((String)tenantId);
            } else if (!TenantIdUtils.getFromMDC().equals(tenantId)) {
                prevTenant = TenantIdUtils.getFromMDC();
                TenantIdUtils.putInMDC((String)tenantId);
            }
            t = requestHandler.apply(requestContext);
            if (!putInMDC) break block28;
            CorrelationIdUtils.clearMDC();
        }
        if (putTenantInMDC) {
            TenantIdUtils.clearMDC();
        } else if (prevTenant != null) {
            TenantIdUtils.putInMDC((String)prevTenant);
        }
        return t;
        {
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (requestContext != null) {
                    if (throwable != null) {
                        try {
                            requestContext.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        requestContext.close();
                    }
                }
            }
            {
                catch (Throwable throwable4) {
                    if (putInMDC) {
                        CorrelationIdUtils.clearMDC();
                    }
                    if (putTenantInMDC) {
                        TenantIdUtils.clearMDC();
                    } else if (prevTenant != null) {
                        TenantIdUtils.putInMDC(prevTenant);
                    }
                    throw throwable4;
                }
            }
        }
    }

    private UserInfo providedUserInfo() {
        UserInfo result;
        if (this.cdsRuntime != null && (result = this.cdsRuntime.getProvidedUserInfo()) != null) {
            return result;
        }
        return UserInfoFactory.anonymousUserInfo();
    }

    private ParameterInfo providedParameterInfo() {
        ParameterInfo result;
        if (this.cdsRuntime != null && (result = this.cdsRuntime.getProvidedParameterInfo()) != null) {
            return result;
        }
        return ParameterInfoFactory.emptyParameterInfo();
    }

    private FeatureTogglesInfo calculateFeatureTogglesInfo() {
        FeatureTogglesInfo result;
        if (this.cdsRuntime != null && (result = this.cdsRuntime.getFeatureTogglesInfo(this.userInfo, this.parameterInfo)) != null) {
            return result;
        }
        return FeatureTogglesInfo.create((FeatureToggle[])new FeatureToggle[0]);
    }

    public RequestContextRunner recalculateFeatureToggles() {
        this.featureTogglesInfo = this.calculateFeatureTogglesInfo();
        return this;
    }
}

