/**************************************************************************
 * (C) 2019-2021 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.services.impl.environment;

import java.util.List;
import java.util.stream.Stream;

import com.sap.cds.services.environment.ServiceBinding;
import com.sap.cds.services.environment.ServiceBindingProvider;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.utils.environment.VcapServicesParser;

public class DefaultServiceBindingProvider implements ServiceBindingProvider {

	private final CdsRuntime runtime;
	private List<ServiceBinding> bindings;

	public DefaultServiceBindingProvider(CdsRuntime runtime) {
		this.runtime = runtime;
	}

	@Override
	public Stream<ServiceBinding> get() {
		if(bindings == null) {
			bindings = VcapServicesParser.getServiceBindings(DefaultEnvFileUtils.getDefaultEnv(runtime));
		}
		return bindings.stream();
	}

}
