/**************************************************************************
 * (C) 2019-2021 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.services.impl.model;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.sap.cds.services.runtime.CdsRuntimeConfiguration;
import com.sap.cds.services.runtime.CdsRuntimeConfigurer;
import com.sap.cds.services.utils.model.DynamicModelUtils;

public class DynamicModelProviderConfiguration implements CdsRuntimeConfiguration {

	private static final Logger logger = LoggerFactory.getLogger(DynamicModelProviderConfiguration.class);

	@Override
	public void providers(CdsRuntimeConfigurer configurer) {
		if (new DynamicModelUtils(configurer.getCdsRuntime()).isDynamicModelEnabled()) {
			logger.info("Loading DynamicModelProvider");
			configurer.provider(new DynamicModelProvider(configurer.getCdsRuntime()));
		}
	}

}
