package com.sap.cds.services.impl.runtime;

import java.util.HashMap;
import java.util.Map;

import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.runtime.CdsRuntimeAware;
import com.sap.cds.services.utils.info.CdsInfo;

public class ProviderInfo implements CdsInfo, CdsRuntimeAware {

	private CdsRuntimeImpl runtime;

	@Override
	public void setCdsRuntime(CdsRuntime runtime) {
		this.runtime = (CdsRuntimeImpl) runtime;
	}

	@Override
	public String name() {
		return "providers";
	}

	@Override
	public Map<String, Class<?>> info(Details details) {
		Map<String, Class<?>> providers = new HashMap<>();
		providers.put("serviceBinding", runtime.getServiceBindingProvider().getClass());
		providers.put("applicationInfo", runtime.getApplicationInfoProvider().getClass());
		providers.put("cdsModel", runtime.getCdsModelProvider().getClass());
		providers.put("userInfo", runtime.getUserInfoProvider().getClass());
		providers.put("authenticationInfo", runtime.getAuthenticationInfoProvider().getClass());
		providers.put("parameterInfo", runtime.getParameterInfoProvider().getClass());
		providers.put("localizedMessage", runtime.getLocalizedMessageProvider().getClass());
		providers.put("featureToggle", runtime.getFeatureToggleProvider().getClass());
		return providers;
	}

}
