/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.runtime.mockusers;

import com.sap.cds.services.authentication.AuthenticationInfo;
import com.sap.cds.services.authentication.BasicAuthenticationInfo;
import com.sap.cds.services.environment.CdsProperties;
import com.sap.cds.services.request.FeatureTogglesInfo;
import com.sap.cds.services.request.ParameterInfo;
import com.sap.cds.services.request.UserInfo;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.runtime.FeatureTogglesInfoProvider;
import java.util.HashMap;
import java.util.List;

public class MockedFeatureTogglesProvider
implements FeatureTogglesInfoProvider {
    private final CdsRuntime runtime;

    public MockedFeatureTogglesProvider(CdsRuntime runtime) {
        this.runtime = runtime;
    }

    public FeatureTogglesInfo get(UserInfo userInfo, ParameterInfo parameterInfo) {
        AuthenticationInfo authInfo = this.runtime.getProvidedAuthenticationInfo();
        if (authInfo != null && authInfo.is(BasicAuthenticationInfo.class)) {
            CdsProperties.Security.Mock mockConfig = this.runtime.getEnvironment().getCdsProperties().getSecurity().getMock();
            List features = mockConfig.getUsers().stream().filter(u -> u.getName() != null && u.getName().equals(userInfo.getName())).findFirst().map(u -> u.getFeatures()).orElse(null);
            if (features == null) {
                features = mockConfig.getTenants().stream().filter(t -> t.getName() != null && t.getName().equals(userInfo.getTenant())).findFirst().map(t -> t.getFeatures()).orElse(null);
            }
            if (features != null) {
                HashMap featureToggles = new HashMap();
                features.stream().forEach(f -> featureToggles.put(f, true));
                return FeatureTogglesInfo.create(featureToggles);
            }
        }
        return null;
    }
}

