/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.utils;

import com.sap.cds.impl.AssociationAnalyzer;
import com.sap.cds.ql.cqn.AnalysisResult;
import com.sap.cds.ql.cqn.CqnElementRef;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.cqn.CqnReference;
import com.sap.cds.ql.cqn.CqnStatement;
import com.sap.cds.ql.cqn.CqnStructuredTypeRef;
import com.sap.cds.reflect.CdsAction;
import com.sap.cds.reflect.CdsAssociationType;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsFunction;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.reflect.CdsService;
import com.sap.cds.reflect.impl.CdsModelReader;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import com.sap.cds.services.utils.StringUtils;
import com.sap.cds.services.utils.model.Privilege;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CdsModelUtils {
    private static final Logger logger = LoggerFactory.getLogger(CdsModelUtils.class);

    private CdsModelUtils() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static CdsModel loadCdsModel(String resourcePathToCSN) {
        if (StringUtils.isEmpty((String)resourcePathToCSN)) {
            return CdsModelReader.read((InputStream)new ByteArrayInputStream("{}".getBytes(StandardCharsets.UTF_8)), (boolean)true);
        }
        ClassLoader classloader = Thread.currentThread().getContextClassLoader();
        try (InputStream is = classloader.getResourceAsStream(resourcePathToCSN);){
            CdsModel csnModel = CdsModelReader.read((InputStream)new BufferedInputStream(is), (boolean)true);
            logger.info("Loaded CDS model from CSN resource path '{}'", (Object)resourcePathToCSN);
            CdsModel cdsModel = csnModel;
            return cdsModel;
        }
        catch (Exception e) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.INVALID_CSN, new Object[]{resourcePathToCSN, e});
        }
    }

    public static String getNameOrEmpty(CdsEntity entity) {
        if (entity == null) {
            return "";
        }
        return entity.getQualifiedName();
    }

    public static CdsEntity getEntityOrThrow(CdsModel model, String entityName) {
        return (CdsEntity)model.findEntity(entityName).orElseThrow(() -> new ErrorStatusException((ErrorStatus)CdsErrorStatuses.ENTITY_NOT_FOUND, new Object[]{entityName}));
    }

    public static CdsService getServiceOrThrow(CdsModel model, String serviceName) {
        return (CdsService)model.findService(serviceName).orElseThrow(() -> new ErrorStatusException((ErrorStatus)CdsErrorStatuses.SERVICE_NOT_FOUND, new Object[]{serviceName}));
    }

    public static Optional<CdsAction> getAction(CdsModel model, String entityName, String actionName) {
        if (entityName == null) {
            return model.findAction(actionName);
        }
        return ((CdsEntity)model.findEntity(entityName).orElseThrow(() -> new ErrorStatusException((ErrorStatus)CdsErrorStatuses.ENTITY_NOT_FOUND, new Object[]{entityName}))).findAction(actionName);
    }

    public static Optional<CdsFunction> getFunction(CdsModel model, String entityName, String functionName) {
        if (entityName == null) {
            return model.findFunction(functionName);
        }
        return ((CdsEntity)model.findEntity(entityName).orElseThrow(() -> new ErrorStatusException((ErrorStatus)CdsErrorStatuses.ENTITY_NOT_FOUND, new Object[]{entityName}))).findFunction(functionName);
    }

    public static List<CdsElement> getAssociationKeys(CdsElement element) {
        ArrayList<CdsElement> keyElements = new ArrayList<CdsElement>();
        if (element != null && element.getType().isAssociation()) {
            CdsAssociationType association = (CdsAssociationType)element.getType().as(CdsAssociationType.class);
            if (association.onCondition().isPresent()) {
                ((CqnPredicate)association.onCondition().get()).tokens().forEach(token -> {
                    if (token instanceof CqnElementRef) {
                        Optional condElement;
                        CqnElementRef ref = (CqnElementRef)token;
                        if (element.getName().equals(ref.firstSegment()) && ref.segments().size() >= 2 && (condElement = association.getTarget().findElement(((CqnReference.Segment)ref.segments().get(1)).id())).isPresent()) {
                            keyElements.add((CdsElement)condElement.get());
                        }
                    }
                });
            } else {
                AssociationAnalyzer.refElements((CdsElement)element).forEach(key -> keyElements.add((CdsElement)key));
            }
        }
        return keyElements;
    }

    public static boolean isAssociationToParentOrChild(String field, CdsEntity entity) {
        return CdsModelUtils.isAssociationToParent(field, entity) || CdsModelUtils.isComposition(field, entity);
    }

    private static CdsAssociationType getAssociationType(String field, CdsEntity entity) {
        Optional optionalAssociation = entity.findAssociation(field);
        if (optionalAssociation.isPresent()) {
            return (CdsAssociationType)((CdsElement)optionalAssociation.get()).getType().as(CdsAssociationType.class);
        }
        return null;
    }

    public static boolean isAssociationToParent(String field, CdsEntity entity) {
        CdsAssociationType type = CdsModelUtils.getAssociationType(field, entity);
        return type != null && type.getTarget().compositions().anyMatch(c -> ((CdsAssociationType)c.getType().as(CdsAssociationType.class)).getTarget().equals(entity));
    }

    public static boolean isComposition(String field, CdsEntity entity) {
        CdsAssociationType type = CdsModelUtils.getAssociationType(field, entity);
        if (type != null) {
            return type.isComposition();
        }
        return false;
    }

    public static CdsEntity getAssociationTarget(String field, CdsEntity entity) {
        if (entity.findAssociation(field).isPresent()) {
            return (CdsEntity)entity.getTargetOf(field);
        }
        return null;
    }

    public static void visitDeep(CdsEntity entity, List<? extends Map<String, Object>> data, EntityDataVisitor visitor) {
        CdsModelUtils.visitDeep(entity, data, null, visitor);
    }

    private static void visitDeep(CdsEntity entity, List<? extends Map<String, Object>> data, CdsElement parent, EntityDataVisitor visitor) {
        if (data == null || data.isEmpty()) {
            return;
        }
        visitor.visit(entity, data, parent);
        entity.associations().forEach(association -> {
            CdsAssociationType type = (CdsAssociationType)association.getType().as(CdsAssociationType.class);
            ArrayList associationData = new ArrayList();
            data.forEach(map -> {
                Object d = map.get(association.getName());
                if (d != null) {
                    if (d instanceof Map) {
                        associationData.add((Map)d);
                    } else if (d instanceof List) {
                        associationData.addAll((List)d);
                    }
                }
            });
            CdsModelUtils.visitDeep(type.getTarget(), associationData, association, visitor);
        });
    }

    public static void visitDeep(CdsEntity entity, Map<String, Object> data, EntitySingleDataVisitor visitor) {
        CdsModelUtils.visitDeep(entity, data, null, null, visitor);
    }

    private static void visitDeep(CdsEntity entity, Map<String, Object> data, CdsElement parent, Map<String, Object> parentData, EntitySingleDataVisitor visitor) {
        if (data == null) {
            return;
        }
        visitor.visit(entity, data, parent, parentData);
        entity.associations().forEach(association -> {
            CdsAssociationType type = (CdsAssociationType)association.getType().as(CdsAssociationType.class);
            Object d = data.get(association.getName());
            if (d != null) {
                if (d instanceof Map) {
                    CdsModelUtils.visitDeep(type.getTarget(), (Map)d, association, data, visitor);
                } else if (d instanceof List) {
                    ((List)d).forEach(e -> CdsModelUtils.visitDeep(type.getTarget(), e, association, data, visitor));
                }
            }
        });
    }

    public static AnalysisResult getEntityPath(CqnStatement statement, CdsModel model) {
        if (statement.isSelect() && statement.asSelect().from().isSelect()) {
            return CdsModelUtils.getEntityPath((CqnStatement)statement.asSelect().from().asSelect(), model);
        }
        return CdsModelUtils.getEntityPath(statement.ref(), model);
    }

    public static CdsEntity getTargetEntity(CqnStatement statement, CdsModel model) {
        return CdsModelUtils.getEntityPath(statement, model).targetEntity();
    }

    public static AnalysisResult getEntityPath(CqnStructuredTypeRef ref, CdsModel model) {
        return com.sap.cds.services.utils.model.CdsModelUtils.getEntityPath((CqnStructuredTypeRef)ref, (CdsModel)model);
    }

    public static boolean isStandardCdsEvent(String event) {
        return event.equals("READ") || event.equals("CREATE") || event.equals("UPDATE") || event.equals("DELETE") || event.equals("UPSERT") || event.equals("DRAFT_NEW") || event.equals("DRAFT_PATCH") || event.equals("DRAFT_CANCEL") || event.equals("DRAFT_CREATE");
    }

    public static boolean isWriteEvent(String event) {
        return event.equals("CREATE") || event.equals("DELETE") || event.equals("UPDATE") || event.equals("UPSERT") || event.equals("draftActivate") || event.equals("draftEdit") || event.equals("DRAFT_NEW") || event.equals("DRAFT_PATCH") || event.equals("draftPrepare") || event.equals("DRAFT_CANCEL") || event.equals("DRAFT_CREATE");
    }

    public static boolean eventIsGranted(String event, String grant) {
        return Privilege.is((String)event, (String)"DRAFT_NEW") && Privilege.is((String)grant, (String)"CREATE") || Privilege.is((String)event, (String)"draftEdit") && Privilege.is((String)grant, (String)"UPDATE") || Privilege.is((String)event, (String)"DRAFT_CANCEL") && (Privilege.is((String)grant, (String)"CREATE") || Privilege.is((String)grant, (String)"UPDATE") || Privilege.is((String)grant, (String)"DELETE")) || (Privilege.is((String)event, (String)"DRAFT_PATCH") || Privilege.is((String)event, (String)"draftActivate") || Privilege.is((String)event, (String)"draftPrepare") || Privilege.is((String)event, (String)"DRAFT_CREATE")) && (Privilege.is((String)grant, (String)"CREATE") || Privilege.is((String)grant, (String)"UPDATE"));
    }

    @FunctionalInterface
    public static interface EntitySingleDataVisitor {
        public void visit(CdsEntity var1, Map<String, Object> var2, CdsElement var3, Map<String, Object> var4);
    }

    @FunctionalInterface
    public static interface EntityDataVisitor {
        public void visit(CdsEntity var1, List<? extends Map<String, Object>> var2, CdsElement var3);
    }
}

