/**************************************************************************
 * (C) 2019-2021 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.services.impl.application;

import com.sap.cds.services.EventContext;
import com.sap.cds.services.ServiceDelegator;
import com.sap.cds.services.application.ApplicationLifecycleService;
import com.sap.cds.services.application.ApplicationPreparedEventContext;
import com.sap.cds.services.application.ApplicationStoppedEventContext;
import com.sap.cds.services.handler.annotations.HandlerOrder;
import com.sap.cds.services.handler.annotations.On;
import com.sap.cds.services.utils.OrderConstants;

public class ApplicationLifecycleServiceImpl extends ServiceDelegator implements ApplicationLifecycleService {

	public ApplicationLifecycleServiceImpl(String name) {
		super(name);
	}

	@Override
	public void applicationPrepared() {
		emit(ApplicationPreparedEventContext.create());
	}

	@Override
	public void applicationStopped() {
		emit(ApplicationStoppedEventContext.create());
	}

	@On
	@HandlerOrder(OrderConstants.On.AUTO_COMPLETE)
	private void autoComplete(EventContext context) {
		context.setCompleted();
	}

}
