package com.sap.cds.services.impl.environment;

import com.sap.cds.services.environment.CdsProperties;
import com.sap.cds.services.environment.PropertiesProvider;

public class SimplePropertiesProvider implements PropertiesProvider {

	private final CdsProperties properties;

	public SimplePropertiesProvider() {
		this(new CdsProperties());
	}

	public SimplePropertiesProvider(CdsProperties properties) {
		this.properties = properties;
	}

	@Override
	@SuppressWarnings("unchecked")
	public <T> T bindPropertyClass(String section, Class<T> clazz) {
		if("cds".equals(section) && CdsProperties.class.equals(clazz)) {
			return (T) properties;
		}
		throw new UnsupportedOperationException("Only CdsProperties is supported");
	}

	@Override
	public String getProperty(String key, String defaultValue) {
		return defaultValue;
	}

	@Override
	public <T> T getProperty(String key, Class<T> asClazz, T defaultValue) {
		return defaultValue;
	}

}
