/**************************************************************************
 * (C) 2019-2021 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.services.impl.messaging.handlers;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.sap.cds.services.application.ApplicationLifecycleService;
import com.sap.cds.services.application.ApplicationPreparedEventContext;
import com.sap.cds.services.application.ApplicationStoppedEventContext;
import com.sap.cds.services.handler.EventHandler;
import com.sap.cds.services.handler.annotations.On;
import com.sap.cds.services.handler.annotations.ServiceName;
import com.sap.cds.services.utils.messaging.service.AbstractMessagingService;

@ServiceName(ApplicationLifecycleService.DEFAULT_NAME)
public class MessagingInitilizationHandler implements EventHandler {

	private static final Logger logger = LoggerFactory.getLogger(MessagingInitilizationHandler.class);

	@On
	protected void initializeMessaging(ApplicationPreparedEventContext context) {
		// start the asynchronous initialization of messaging services (connection & subscriptions)
		context.getServiceCatalog().getServices(AbstractMessagingService.class).forEach(service -> service.init());

		// check if service is available for the configuration
		context.getCdsRuntime().getEnvironment().getCdsProperties().getMessaging().getServices().forEach((name, config) -> {
			if (config.isEnabled() && context.getServiceCatalog().getService(config.getName()) == null) {
				logger.warn("No messaging service was created for configuration with name '{}'", config.getName());
			}
		});
	}

	@On
	protected void stopMessaging(ApplicationStoppedEventContext context) {
		context.getServiceCatalog().getServices(AbstractMessagingService.class).forEach(service -> service.stop());
	}

}
