/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.auditlog;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.sap.cds.CdsData;
import com.sap.cds.impl.parser.StructDataParser;
import com.sap.cds.reflect.CdsEvent;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.reflect.impl.CdsModelReader;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.EventContext;
import com.sap.cds.services.Service;
import com.sap.cds.services.auditlog.Action;
import com.sap.cds.services.handler.EventHandler;
import com.sap.cds.services.handler.annotations.On;
import com.sap.cds.services.handler.annotations.ServiceName;
import com.sap.cds.services.outbox.OutboxMessageEventContext;
import com.sap.cds.services.outbox.OutboxService;
import com.sap.cds.services.request.RequestContext;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

@ServiceName(value={"*"}, type={OutboxService.class})
public class AuditLogDefaultOutboxOnHandler
implements EventHandler {
    public static final String OUTBOX_AUDITLOG_TARGET = "auditlog/AuditlogService$Default";
    private static final JsonMapper mapper = new JsonMapper();
    private static final String USER = "user";
    private static final String TENANT = "tenant";
    private static final String EVENT = "event";
    private static final String DATA = "data";
    private static final String CREATED_AT = "createdAt";
    private static final String ACTION = "action";
    private static final String MODIFICATIONS = "modifications";
    private CdsModel auditlogModel;

    public AuditLogDefaultOutboxOnHandler() {
        String csnPath = "auditlog.csn";
        try (InputStream is = AuditLogDefaultOutboxOnHandler.class.getClassLoader().getResourceAsStream(csnPath);){
            if (is == null) {
                throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.NO_AUDITLOG_MODEL, new Object[]{csnPath});
            }
            this.auditlogModel = CdsModelReader.read((InputStream)is);
        }
        catch (IOException e) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.AUDITLOG_NOT_READABLE, new Object[]{csnPath, e});
        }
    }

    @On(event={"auditlog/AuditlogService$Default"})
    private void publishedByOutbox(OutboxMessageEventContext context) {
        Service auditlogService = context.getServiceCatalog().getService("AuditlogService$Default");
        if (auditlogService != null) {
            EventContextAccessor contextAccessor = new EventContextAccessor(context, this.auditlogModel);
            context.getCdsRuntime().requestContext().modifyUser(u -> {
                u.setName(contextAccessor.getUser());
                u.setTenant(contextAccessor.getTenant());
            }).run(req -> auditlogService.emit(contextAccessor.getContext()));
        }
    }

    static String createOutboxMessage(EventContext context, CdsRuntime runtime) {
        RequestContext requestContext = RequestContext.getCurrent((CdsRuntime)runtime);
        try {
            CdsData data = (CdsData)context.get(DATA);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put(USER, requestContext.getUserInfo().getName());
            map.put(TENANT, requestContext.getUserInfo().getTenant());
            map.put(EVENT, context.getEvent());
            map.put(DATA, data.toJson());
            return mapper.writeValueAsString(map);
        }
        catch (Exception e) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.CONTEXT_SERIALIZATION_FAILED, new Object[]{context.getEvent(), e});
        }
    }

    private static class EventContextAccessor {
        private String user;
        private String tenant;
        private EventContext context;

        private EventContextAccessor(OutboxMessageEventContext outboxContext, CdsModel auditlogModel) {
            try {
                Map contextData = (Map)mapper.readValue(outboxContext.getMessage(), (TypeReference)new TypeReference<Map<String, Object>>(){});
                this.user = (String)contextData.get(AuditLogDefaultOutboxOnHandler.USER);
                this.tenant = (String)contextData.get(AuditLogDefaultOutboxOnHandler.TENANT);
                String event = (String)contextData.get(AuditLogDefaultOutboxOnHandler.EVENT);
                this.context = EventContext.create((String)event, null);
                CdsEvent type = auditlogModel.getEvent("com.sap.cds.services.auditlog." + event);
                Map data = StructDataParser.create((CdsStructuredType)type).parseObject((String)contextData.get(AuditLogDefaultOutboxOnHandler.DATA));
                this.adaptActionType(data, event);
                this.context.put(AuditLogDefaultOutboxOnHandler.DATA, (Object)data);
                this.context.put(AuditLogDefaultOutboxOnHandler.CREATED_AT, (Object)outboxContext.getTimestamp());
                this.context.put("IS_OUTBOXED", (Object)true);
            }
            catch (Exception e) {
                throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.CONTEXT_DESERIALIZATION_FAILED, new Object[]{outboxContext.getEvent(), e});
            }
        }

        private void adaptActionType(Map<String, Object> data, String event) {
            Object action;
            if (event.equals("dataModificationLog")) {
                Collection modifications = (Collection)data.get(AuditLogDefaultOutboxOnHandler.MODIFICATIONS);
                if (modifications != null) {
                    modifications.forEach(modification -> {
                        Object action = modification.get(AuditLogDefaultOutboxOnHandler.ACTION);
                        if (action != null) {
                            modification.put(AuditLogDefaultOutboxOnHandler.ACTION, Action.valueOf((String)action.toString()));
                        }
                    });
                }
            } else if (event.equals("configChangeLog") && (action = data.get(AuditLogDefaultOutboxOnHandler.ACTION)) != null) {
                data.put(AuditLogDefaultOutboxOnHandler.ACTION, Action.valueOf((String)action.toString()));
            }
        }

        public String getUser() {
            return this.user;
        }

        public String getTenant() {
            return this.tenant;
        }

        public EventContext getContext() {
            return this.context;
        }
    }
}

