/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.cds;

import com.sap.cds.reflect.CdsAnnotatable;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.services.EventContext;
import com.sap.cds.services.cds.ApplicationService;
import com.sap.cds.services.handler.EventHandler;
import com.sap.cds.services.handler.annotations.Before;
import com.sap.cds.services.handler.annotations.HandlerOrder;
import com.sap.cds.services.handler.annotations.ServiceName;
import com.sap.cds.services.impl.utils.ValidatorUtils;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.StringUtils;
import com.sap.cds.services.utils.model.CdsAnnotations;
import java.util.Map;
import java.util.function.Predicate;

@ServiceName(value={"*"}, type={ApplicationService.class})
public class MandatoryHandler
implements EventHandler {
    protected static Predicate<CdsElement> requiresMandatoryCheck() {
        return element -> {
            Map commonFieldControl;
            if (!ValidatorUtils.requiresNotNullCheck(element)) {
                return false;
            }
            if (CdsAnnotations.ODATA_FOREIGN_KEY_FOR.getOrValue((CdsAnnotatable)element, null) != null) {
                return false;
            }
            boolean mandatory = CdsAnnotations.MANDATORY.isTrue((CdsAnnotatable)element);
            return mandatory || (commonFieldControl = (Map)CdsAnnotations.COMMON_FIELDCONTROL.getOrDefault((CdsAnnotatable)element)) != null && "Mandatory".equals(commonFieldControl.get("#"));
        };
    }

    @Before(event={"CREATE", "UPDATE", "UPSERT"})
    @HandlerOrder(value=11100)
    public void runCheck(EventContext context) {
        ValidatorUtils.runNotNullCheck(context, MandatoryHandler.requiresMandatoryCheck(), ValidatorUtils.assertNotNull(context, value -> value == null || value instanceof String && StringUtils.isEmpty((String)((String)value)), (path, element, entity) -> ValidatorUtils.handleValidationError(context, path, element, CdsErrorStatuses.VALUE_REQUIRED, element.getName(), entity)));
    }
}

