/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.model;

import com.sap.cds.mtx.MetaDataAccessor;
import com.sap.cds.mtx.ModelId;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.services.request.FeatureTogglesInfo;
import com.sap.cds.services.request.UserInfo;
import com.sap.cds.services.runtime.CdsModelProvider;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.utils.model.DynamicModelUtils;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicModelProvider
implements CdsModelProvider {
    private static final Logger logger = LoggerFactory.getLogger(DynamicModelProvider.class);
    private final CdsRuntime runtime;
    private final MetaDataAccessor<String> accessor;
    private final boolean modelProviderEnabled;

    public DynamicModelProvider(CdsRuntime runtime) {
        this.runtime = runtime;
        DynamicModelUtils utils = new DynamicModelUtils(runtime);
        this.accessor = utils.createMetadataAccessor((edmx, service) -> edmx);
        this.modelProviderEnabled = utils.isModelProviderEnabled();
    }

    public CdsModel get(UserInfo userInfo, FeatureTogglesInfo featureTogglesInfo) {
        String tenant = userInfo.getTenant();
        boolean hasAllToggles = featureTogglesInfo.getEnabledFeatureToggles().anyMatch(t -> t.getName().trim().equals("*"));
        if (tenant == null && (!this.modelProviderEnabled || hasAllToggles)) {
            return this.runtime.getCdsModel();
        }
        logger.debug("Fetching the model for tenant '{}' and feature toggles '{}'", (Object)tenant, (Object)featureTogglesInfo.getFeatureToggles().map(ft -> ft.getName() + ": " + ft.isEnabled()).collect(Collectors.joining(",")));
        Set features = featureTogglesInfo.getEnabledFeatureToggles().map(ft -> ft.getName()).collect(Collectors.toSet());
        ModelId modelId = ModelId.create((String)tenant).features(features).build();
        int maxAgeSeconds = Integer.MAX_VALUE;
        return this.accessor.getCdsModel(modelId, maxAgeSeconds);
    }
}

