/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.request;

import com.sap.cds.services.impl.utils.ModifiedValues;
import com.sap.cds.services.request.ModifiableParameterInfo;
import com.sap.cds.services.request.ParameterInfo;
import com.sap.cds.services.utils.TemporalRangeUtils;
import java.time.Instant;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

class ModifiableParameterInfoImpl
implements ModifiableParameterInfo {
    private final ModifiedValues modifyValues = new ModifiedValues();
    private final ModifiedValues.MapProperty<String, String> headers;
    private final ModifiedValues.MapProperty<String, String> queryParams;
    private final ModifiedValues.Property<String> correlationId;
    private final ModifiedValues.Property<Locale> locale = this.modifyValues.field("locale", () -> ((ParameterInfo)prevParameterInfo).getLocale());
    private final ModifiedValues.Property<Instant> validFrom;
    private final ModifiedValues.Property<Instant> validTo;

    ModifiableParameterInfoImpl(@Nonnull ParameterInfo prevParameterInfo) {
        this.headers = this.modifyValues.field("headers", () -> ((ParameterInfo)prevParameterInfo).getHeaders(), arg_0 -> ((ParameterInfo)prevParameterInfo).getHeader(arg_0));
        this.validFrom = this.modifyValues.field("validFrom", () -> ((ParameterInfo)prevParameterInfo).getValidFrom());
        this.validTo = this.modifyValues.field("validTo", () -> ((ParameterInfo)prevParameterInfo).getValidTo());
        this.queryParams = this.modifyValues.field("queryParams", () -> ((ParameterInfo)prevParameterInfo).getQueryParams(), arg_0 -> ((ParameterInfo)prevParameterInfo).getQueryParameter(arg_0));
        this.correlationId = this.modifyValues.field("correlationId", () -> ((ParameterInfo)prevParameterInfo).getCorrelationId());
    }

    public Map<String, String> getHeaders() {
        return (Map)this.headers.getValue();
    }

    public ModifiableParameterInfo setHeaders(Map<String, String> val) {
        this.headers.modifyValue(val);
        return this;
    }

    public String getHeader(String id) {
        return this.headers.getMapValue(id);
    }

    public ModifiableParameterInfo setHeader(String id, String value) {
        this.headers.modifyMapValue(id, value);
        return this;
    }

    public Map<String, String> getQueryParams() {
        return (Map)this.queryParams.getValue();
    }

    public ModifiableParameterInfo setQueryParameters(Map<String, String> val) {
        this.queryParams.modifyValue(val);
        return this;
    }

    public String getQueryParameter(String key) {
        return this.queryParams.getMapValue(key);
    }

    public ModifiableParameterInfo setQueryParameter(String key, String value) {
        this.queryParams.modifyMapValue(key, value);
        return this;
    }

    public Stream<String> getQueryParameters() {
        return this.getQueryParams().keySet().stream();
    }

    public String getCorrelationId() {
        return this.correlationId.getValue();
    }

    public Locale getLocale() {
        return this.locale.getValue();
    }

    public ModifiableParameterInfo setLocale(Locale val) {
        this.locale.modifyValue(val);
        return this;
    }

    public Instant getValidFrom() {
        return this.validFrom.getValue();
    }

    public ModifiableParameterInfo setValidFrom(Instant val) {
        this.validFrom.modifyValue(val);
        return this;
    }

    public Instant getValidTo() {
        return this.validTo.getValue();
    }

    public ModifiableParameterInfo setValidTo(Instant val) {
        this.validTo.modifyValue(val);
        return this;
    }

    public ModifiableParameterInfo setValidAt(Instant validAt) {
        Instant[] range = TemporalRangeUtils.getTemporalRanges((Instant)validAt);
        this.setValidFrom(range[0]);
        this.setValidTo(range[1]);
        return this;
    }
}

