/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.runtime;

import com.sap.cds.services.changeset.ChangeSetContext;
import com.sap.cds.services.impl.changeset.ChangeSetContextImpl;
import com.sap.cds.services.impl.runtime.CdsRuntimeImpl;
import com.sap.cds.services.request.RequestContext;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.runtime.ChangeSetContextRunner;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangeSetContextRunnerImpl
implements ChangeSetContextRunner {
    private static final Logger logger = LoggerFactory.getLogger(CdsRuntimeImpl.class);
    private final CdsRuntime runtime;

    public ChangeSetContextRunnerImpl(CdsRuntime runtime) {
        this.runtime = Objects.requireNonNull(runtime, "runtime must not be null");
    }

    public <T> T run(Function<ChangeSetContext, T> changeSetHandler) {
        if (!RequestContext.isActive()) {
            return (T)this.runtime.requestContext().run(requestContext -> this.open(changeSetHandler));
        }
        return this.open(changeSetHandler);
    }

    public void run(Consumer<ChangeSetContext> changeSetHandler) {
        this.run((ChangeSetContext changeSetContext) -> {
            changeSetHandler.accept((ChangeSetContext)changeSetContext);
            return Void.TYPE;
        });
    }

    private <T> T open(Function<ChangeSetContext, T> handler) {
        Throwable throwable = null;
        try (ChangeSetContextImpl changeSetContext = ChangeSetContextImpl.open();){
            T t = handler.apply((ChangeSetContext)changeSetContext);
            return t;
        }
        catch (Exception e) {
            try {
                changeSetContext.markForCancel();
                logger.info("Exception marked the ChangeSet {} as cancelled: {}", (Object)changeSetContext.getId(), (Object)e.getMessage());
                throw e;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }
}

