/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.authorization;

import com.sap.cds.impl.parser.ExpressionParser;
import com.sap.cds.ql.CQL;
import com.sap.cds.ql.Predicate;
import com.sap.cds.ql.Select;
import com.sap.cds.ql.StructuredTypeRef;
import com.sap.cds.ql.Value;
import com.sap.cds.ql.cqn.CqnComparisonPredicate;
import com.sap.cds.ql.cqn.CqnMatchPredicate;
import com.sap.cds.ql.cqn.CqnModifier;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.cqn.CqnReference;
import com.sap.cds.ql.cqn.CqnValue;
import com.sap.cds.ql.cqn.Modifier;
import com.sap.cds.services.request.UserInfo;
import com.sap.cds.services.utils.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class PredicateResolver {
    static final Predicate UNRESTRICTED_PRED = CQL.constant((Object)1).eq((Value)CQL.constant((Object)1));
    static final Predicate FORBIDDEN_PRED = CQL.constant((Object)1).eq((Value)CQL.constant((Object)0));
    static final boolean TREAT_EMPTY_ATTRIBUTES_AS_RESTRICTED = false;
    private final CqnPredicate unresolvedPred;

    private PredicateResolver(CqnPredicate pred) {
        this.unresolvedPred = pred;
    }

    static PredicateResolver create(String cxnExpression) {
        Predicate pred = !StringUtils.isEmpty((String)cxnExpression) ? ExpressionParser.parsePredicate((String)cxnExpression) : UNRESTRICTED_PRED;
        return new PredicateResolver((CqnPredicate)pred);
    }

    CqnPredicate resolve(UserInfo user) {
        return CQL.copy((CqnPredicate)this.unresolvedPred, (Modifier)new UserAttributeSubstitutor(user));
    }

    public static class MultipleAttributeValuesNotSupportedException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
        private final String attributeName;
        private final String resourceName;

        MultipleAttributeValuesNotSupportedException(String resourceName, String attributeName) {
            this.resourceName = resourceName;
            this.attributeName = attributeName;
        }

        public String getAttributeName() {
            return this.attributeName;
        }

        public String getResourceName() {
            return this.resourceName;
        }
    }

    private static class UserAttributeSubstitutor
    implements CqnModifier {
        private static final String USER = "$user";
        private static final String TENANT = "tenant";
        private static List<CqnValue> UNRESTRICTED_VALUE = null;
        private static List<CqnValue> FORBIDDEN_VALUE = Collections.emptyList();
        private final UserInfo userInfo;

        public UserAttributeSubstitutor(UserInfo userInfo) {
            this.userInfo = userInfo;
        }

        public Predicate comparison(Value<?> lhs, CqnComparisonPredicate.Operator op, Value<?> rhs) {
            List<CqnValue> lhsValues = this.resolveUserValues((CqnValue)lhs);
            List<CqnValue> rhsValues = this.resolveUserValues((CqnValue)rhs);
            if (lhsValues == FORBIDDEN_VALUE || rhsValues == FORBIDDEN_VALUE) {
                return FORBIDDEN_PRED;
            }
            if (lhsValues == UNRESTRICTED_VALUE || rhsValues == UNRESTRICTED_VALUE) {
                return UNRESTRICTED_PRED;
            }
            ArrayList<Predicate> preds = new ArrayList<Predicate>(lhsValues.size() * rhsValues.size());
            for (CqnValue lhsVal : lhsValues) {
                for (CqnValue rhsVal : rhsValues) {
                    preds.add(CQL.comparison((CqnValue)lhsVal, (CqnComparisonPredicate.Operator)op, (CqnValue)rhsVal));
                }
            }
            return CQL.or(preds);
        }

        public Predicate in(Value<?> value, CqnValue valueSet) {
            List<Object> rhsValues;
            List<CqnValue> lhsValues = this.resolveUserValues((CqnValue)value);
            if (lhsValues == FORBIDDEN_VALUE) {
                return FORBIDDEN_PRED;
            }
            if (lhsValues == UNRESTRICTED_VALUE) {
                return UNRESTRICTED_PRED;
            }
            if (valueSet.isList()) {
                rhsValues = new ArrayList();
                for (CqnValue listValue : valueSet.asList().values().collect(Collectors.toList())) {
                    List<CqnValue> listValues = this.resolveUserValues(listValue);
                    if (listValues == FORBIDDEN_VALUE) {
                        return FORBIDDEN_PRED;
                    }
                    if (listValues == UNRESTRICTED_VALUE) {
                        return UNRESTRICTED_PRED;
                    }
                    rhsValues.addAll(listValues);
                }
            } else {
                rhsValues = this.resolveUserValues(valueSet);
                if (rhsValues == FORBIDDEN_VALUE) {
                    return FORBIDDEN_PRED;
                }
                if (rhsValues == UNRESTRICTED_VALUE) {
                    return UNRESTRICTED_PRED;
                }
            }
            return CQL.or((Iterable)lhsValues.stream().map(v -> CQL.in((CqnValue)v, (Collection)rhsValues)).collect(Collectors.toList()));
        }

        public Predicate exists(Select<?> subQuery) {
            subQuery.where().ifPresent(w -> subQuery.where((CqnPredicate)CQL.copy((CqnPredicate)w, (Modifier)this)));
            return super.exists(subQuery);
        }

        public Predicate match(StructuredTypeRef ref, Predicate pred, CqnMatchPredicate.Quantifier quantifier) {
            return super.match(ref, pred != null ? CQL.copy((CqnPredicate)pred, (Modifier)this) : pred, quantifier);
        }

        public Value<?> function(String name, List<Value<?>> args, String cdsType) {
            for (int i = 0; i < args.size(); ++i) {
                List<CqnValue> resolvedValue = this.resolveUserValues((CqnValue)args.get(i));
                if (resolvedValue.size() != 1) {
                    throw new MultipleAttributeValuesNotSupportedException(name, this.extractUserAttribute((CqnValue)args.get(i)));
                }
                args.set(i, (Value)resolvedValue.get(0));
            }
            return super.function(name, args, cdsType);
        }

        public Predicate booleanFunction(String name, List<Value<?>> args) {
            for (int i = 0; i < args.size(); ++i) {
                List<CqnValue> resolvedValue = this.resolveUserValues((CqnValue)args.get(i));
                if (resolvedValue.size() != 1) {
                    throw new MultipleAttributeValuesNotSupportedException(name, this.extractUserAttribute((CqnValue)args.get(i)));
                }
                args.set(i, (Value)resolvedValue.get(0));
            }
            return super.booleanFunction(name, args);
        }

        private List<CqnValue> resolveUserValues(CqnValue val) {
            String userAttribute = this.extractUserAttribute(val);
            if (userAttribute == null) {
                return Arrays.asList(val);
            }
            switch (userAttribute) {
                case "$user": {
                    return !StringUtils.isEmpty((String)this.userInfo.getName()) ? Arrays.asList(CQL.constant((Object)this.userInfo.getName())) : FORBIDDEN_VALUE;
                }
                case "tenant": {
                    return !StringUtils.isEmpty((String)this.userInfo.getTenant()) ? Arrays.asList(CQL.constant((Object)this.userInfo.getTenant())) : FORBIDDEN_VALUE;
                }
            }
            if (this.userInfo.isUnrestrictedAttribute(userAttribute)) {
                return UNRESTRICTED_VALUE;
            }
            List attributeValues = this.userInfo.getAttributeValues(userAttribute);
            if (attributeValues == null || attributeValues.isEmpty()) {
                return UNRESTRICTED_VALUE;
            }
            return attributeValues.stream().map(v -> CQL.constant((Object)v)).collect(Collectors.toList());
        }

        private String extractUserAttribute(CqnValue val) {
            List segments;
            if (val.isRef() && !(segments = val.asRef().segments()).isEmpty() && USER.equalsIgnoreCase(((CqnReference.Segment)segments.get(0)).id())) {
                if (segments.size() == 1) {
                    return USER;
                }
                String attribute = ((CqnReference.Segment)segments.get(1)).id();
                if (TENANT.equalsIgnoreCase(attribute)) {
                    return TENANT;
                }
                return attribute;
            }
            return null;
        }
    }
}

