package com.sap.cds.services.impl.messaging.message;

import java.util.List;
import java.util.stream.Collectors;

import com.sap.cds.reflect.CdsEvent;
import com.sap.cds.services.ServiceCatalog;
import com.sap.cds.services.impl.messaging.composite.MessagingCompositeService;
import com.sap.cds.services.messaging.MessagingService;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import com.sap.cds.services.utils.StringUtils;
import com.sap.cds.services.utils.model.CdsAnnotations;

/**
 * Utilities for the Logical Messaging Layer
 */
public class CdsMessagingUtils {

	public static MessagingService getMessagingService(CdsRuntime runtime) {
		ServiceCatalog catalog = runtime.getServiceCatalog();

		// check whether the composite service is available
		MessagingCompositeService compositeService = catalog.getService(MessagingCompositeService.class, MessagingCompositeService.COMPOSITE_NAME);
		if (compositeService != null) {
			return compositeService;
		}

		// otherwise check whether a messaging service can be determined
		List<MessagingService> services = catalog.getServices(MessagingService.class).collect(Collectors.toList());
		if (services.isEmpty()) {
			return null;
		} else if (services.size() > 1) {
			throw new ErrorStatusException(CdsErrorStatuses.MULTIPLE_MESSAGINGSERVICE);
		}
		return services.get(0);
	}

	public static String getTopic(CdsEvent event) {
		String topic = CdsAnnotations.TOPIC.getOrDefault(event);
		return StringUtils.isEmpty(topic) ? event.getQualifiedName() : topic;
	}
}
