/**************************************************************************
 * (C) 2019-2021 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.services.impl.utils;

import java.util.List;

import com.sap.cds.ql.CQL;
import com.sap.cds.ql.Expand;
import com.sap.cds.ql.StructuredTypeRef;
import com.sap.cds.ql.cqn.CqnModifier;
import com.sap.cds.ql.cqn.CqnSelectListItem;
import com.sap.cds.ql.impl.ExpressionVisitor;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.services.utils.model.CdsModelUtils;

public abstract class TargetAwareCqnModifier implements CqnModifier {

	private final CdsEntity target;

	public TargetAwareCqnModifier(CdsEntity target) {
		this.target = target;
	}

	protected abstract TargetAwareCqnModifier create(CdsEntity target);

	@Override
	public CqnSelectListItem expand(Expand<?> expand) {
		CdsEntity refTarget = getRefTarget(expand.ref());
		List<CqnSelectListItem> items = expand.items();
		if(refTarget != null) {
			// copy selection deep
			CqnModifier modifier = create(refTarget);
			items = modifier.items(ExpressionVisitor.copy(items, modifier));
		}

		Expand<?> modifiedExpand = CQL.to(expand.ref().segments()).expand(items).orderBy(expand.orderBy()).limit(expand.top(), expand.skip());
		return CqnModifier.super.expand(modifiedExpand);
	}

	protected CdsEntity getTarget() {
		return target;
	}

	protected CdsEntity getRefTarget(StructuredTypeRef ref) {
		return CdsModelUtils.getRefTarget(ref, target);
	}

}
