/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.messages;

import com.sap.cds.ql.StructuredType;
import com.sap.cds.ql.cqn.Path;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.services.impl.messages.MessageTargetImpl;
import com.sap.cds.services.messages.Message;
import com.sap.cds.services.messages.MessageTarget;
import java.util.Objects;
import java.util.function.Function;

public class MessageImpl
implements Message {
    private final Message.Severity severity;
    private final String message;
    private String code;
    private String longTextUrl;
    private MessageTarget target;

    public MessageImpl(Message.Severity severity, String message) {
        this.message = Objects.requireNonNull(message, "message must not be null");
        this.severity = Objects.requireNonNull(severity, "severity must not be null");
    }

    public String getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public Message.Severity getSeverity() {
        return this.severity;
    }

    public MessageTarget getTarget() {
        return this.target;
    }

    public String getLongTextUrl() {
        return this.longTextUrl;
    }

    public Message longTextUrl(String longTextUrl) {
        this.longTextUrl = longTextUrl;
        return this;
    }

    public Message code(String code) {
        this.code = code;
        return this;
    }

    public Message target(String target) {
        this.target = MessageTargetImpl.create(target);
        return this;
    }

    public Message target(Function<StructuredType<?>, Object> path) {
        return this.target("cqn", path);
    }

    public Message target(String parameter, Function<StructuredType<?>, Object> path) {
        this.target = MessageTargetImpl.create(parameter, path);
        return this;
    }

    public Message target(String prefix, String entity, Function<StructuredType<?>, Object> path) {
        this.target = MessageTargetImpl.create(prefix, entity, path);
        return this;
    }

    public <E extends StructuredType<E>> Message target(Class<E> type, Function<E, Object> path) {
        return this.target("cqn", type, path);
    }

    public <E extends StructuredType<E>> Message target(String parameter, Class<E> type, Function<E, Object> path) {
        this.target = MessageTargetImpl.create(parameter, type, path);
        return this;
    }

    public Message target(Path path, CdsElement element) {
        this.target = MessageTargetImpl.create(path, element);
        return this;
    }

    public Message target(MessageTarget target) {
        this.target = target;
        return this;
    }
}

