/**************************************************************************
 * (C) 2019-2021 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.services.impl.authorization;

import com.sap.cds.services.EventContext;
import com.sap.cds.services.impl.EventContextDelegator;
import com.sap.cds.services.authorization.AuthorizationService;
import com.sap.cds.services.authorization.FunctionAccessEventContext;

public class FunctionAccessEventContextImpl extends EventContextDelegator implements FunctionAccessEventContext {

	public FunctionAccessEventContextImpl(EventContext eventContext) {
		super(eventContext);
	}

	@Override
	public AuthorizationService getService() {
		return (AuthorizationService) super.getService();
	}

	private static final String PARAM_FUNCTION_NAME = "functionName";

	private static final String PARAM_ENTITY_NAME = "entityName";
	
	private static final String PARAM_RESULT = "result";
		
	// IN
	public void setFunctionName(String functionName) {
		put(PARAM_FUNCTION_NAME, functionName);
	}

	public String getFunctionName() {
		return (String)get(PARAM_FUNCTION_NAME);
	}

	public void setEntityName(String event) {
		put(PARAM_ENTITY_NAME, event);
	}

	public String getEntityName() {
		return (String)get(PARAM_ENTITY_NAME);
	}

	// OUT
	public Boolean getResult() {
		return (Boolean)get(PARAM_RESULT);
	}

	public void setResult(boolean result) {
		put(PARAM_RESULT, result);
		setCompleted();
	}
}
