/**************************************************************************
 * (C) 2019-2021 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.services.impl.draft;

import java.util.ArrayList;
import java.util.List;

import com.sap.cds.ql.CQL;
import com.sap.cds.ql.Expand;
import com.sap.cds.ql.StructuredTypeRef;
import com.sap.cds.ql.cqn.CqnSelectListItem;
import com.sap.cds.ql.cqn.Modifier;
import com.sap.cds.ql.impl.ExpressionVisitor;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.services.EventContext;
import com.sap.cds.services.utils.model.CdsModelUtils;

/**
 * A {@link Modifier} for expand and inline parts of the statement
 */
public class SelectListModifier implements Modifier {

	private final CdsEntity target;
	private final List<Boolean> followActiveAssociations;
	private final EventContext context;

	public SelectListModifier(CdsEntity target, List<Boolean> followActiveAssociations, EventContext context) {
		this.target = target;
		this.followActiveAssociations = followActiveAssociations; // NOSONAR
		this.context = context;
	}

	@Override
	public CqnSelectListItem expand(Expand<?> expand) {
		StructuredTypeRef newRef = ExpressionVisitor.copy(expand.ref(), new ReferenceModifier(target, followActiveAssociations, true, context));
		Modifier columnModifier = new ColumnsModifier(CdsModelUtils.getRefTarget(newRef, target), context);
		Expand<?> modifiedExpand = CQL.to(newRef.segments())
				.expand(columnModifier.items(new ArrayList<>(expand.items())))
				.orderBy(columnModifier.orderBy(new ArrayList<>(expand.orderBy())))
				.limit(expand.top(), expand.skip());
		return Modifier.super.expand(modifiedExpand);
	}

	@Override
	public CqnSelectListItem inline(StructuredTypeRef ref, List<CqnSelectListItem> items) {
		StructuredTypeRef newRef = ExpressionVisitor.copy(ref, new ReferenceModifier(target, followActiveAssociations, true, context));
		Modifier columnModifier = new ColumnsModifier(CdsModelUtils.getRefTarget(newRef, target), context);
		return Modifier.super.inline(newRef, columnModifier.items(items));
	}

}
