/**************************************************************************
 * (C) 2019-2021 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.services.impl.messaging.local;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.sap.cds.services.ServiceException;
import com.sap.cds.services.environment.CdsProperties.Messaging.MessagingServiceConfig;
import com.sap.cds.services.messaging.MessagingErrorEventContext;
import com.sap.cds.services.messaging.TopicMessageEventContext;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.utils.messaging.service.AbstractMessagingService;
import com.sap.cds.services.utils.messaging.service.MessagingBrokerQueueListener;

public class LocalMessagingService extends AbstractMessagingService {

	public static final String LOCAL_KIND = "local-messaging";
	private static final Logger logger = LoggerFactory.getLogger(LocalMessagingService.class);

	private final ExecutorService executor = Executors.newCachedThreadPool();

	public LocalMessagingService(MessagingServiceConfig serviceConfig, CdsRuntime runtime) {
		super(serviceConfig, runtime);
	}

	@Override
	public void init() {
		// nothing to do
	}

	@Override
	protected void removeQueue(String name) {
		// nothing to do
	}

	@Override
	protected void createQueue(String name, Map<String, String> properties) {
		// nothing to do
	}

	@Override
	protected void createQueueSubscription(String queue, String topic) {
		// nothing to do
	}

	@Override
	protected void registerQueueListener(String queue, MessagingBrokerQueueListener listener) {
		// nothing to do
	}

	@Override
	protected String toFullyQualifiedTopicName(String event, boolean inbound) {
		return event;
	}

	@Override
	protected void emitTopicMessage(String topic, TopicMessageEventContext messageEventContext) {
		// only receive event if someone subscribed to it
		if(queue.hasEvent(topic)) {
			try {
				// execute in a separate thread to align with actual messaging behaviour
				executor.submit(() -> {
					runtime.requestContext().privilegedUser().run(context -> {
						try {
							TopicMessageEventContext incoming = TopicMessageEventContext.create(topic);
							incoming.setIsInbound(true);
							incoming.setData(messageEventContext.getData());
							incoming.setMessageId(UUID.randomUUID().toString());
							emit(incoming);
						} catch (Throwable th) {
							MessagingErrorEventContext errorContext = MessagingErrorEventContext.create();
							ServiceException e = th instanceof ServiceException ? (ServiceException) th : new ServiceException(th);
							errorContext.setException(e);
							emit(errorContext);
							throw th;
						}
					});
				}).get();
			} catch (InterruptedException e) {
				Thread.currentThread().interrupt();
			} catch (ExecutionException e) {
				throw new ServiceException(e.getCause());
			}
		} else {
			logger.debug("Topic '{}' does not have any subscriptions. Message '{}' is discarded.",
					topic, messageEventContext.getData());
		}
	}

}
