/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.auditlog;

import com.sap.cds.CdsDataProcessor;
import com.sap.cds.Result;
import com.sap.cds.impl.DataProcessor;
import com.sap.cds.ql.CQL;
import com.sap.cds.ql.cqn.CqnSelect;
import com.sap.cds.ql.cqn.CqnStatement;
import com.sap.cds.ql.cqn.Modifier;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.services.auditlog.Access;
import com.sap.cds.services.auditlog.AuditLogService;
import com.sap.cds.services.cds.ApplicationService;
import com.sap.cds.services.cds.CdsReadEventContext;
import com.sap.cds.services.handler.EventHandler;
import com.sap.cds.services.handler.annotations.After;
import com.sap.cds.services.handler.annotations.Before;
import com.sap.cds.services.handler.annotations.HandlerOrder;
import com.sap.cds.services.handler.annotations.ServiceName;
import com.sap.cds.services.impl.auditlog.PersonalDataAnalyzerAccess;
import com.sap.cds.services.impl.auditlog.PersonalDataCaches;
import com.sap.cds.services.impl.auditlog.PersonalDataModifier;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.util.CqnStatementUtils;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@ServiceName(value={"*"}, type={ApplicationService.class})
class ApplicationServicePersonalDataHandler
implements EventHandler {
    private static final String PD_ANALYZER_ACCESS_KEY = PersonalDataAnalyzerAccess.class.getCanonicalName();
    private final PersonalDataCaches caches;
    private final CdsRuntime runtime;
    private final AuditLogService auditLog;

    ApplicationServicePersonalDataHandler(PersonalDataCaches caches, CdsRuntime runtime) {
        this.caches = Objects.requireNonNull(caches, "caches must not be null");
        this.runtime = Objects.requireNonNull(runtime, "runtime must not be null");
        this.auditLog = (AuditLogService)runtime.getServiceCatalog().getService(AuditLogService.class, "AuditlogService$Default");
    }

    @Before
    @HandlerOrder(value=11300)
    protected void beforeRead(CdsReadEventContext context) {
        CdsEntity entity = context.getTarget();
        PersonalDataModifier modifier = new PersonalDataModifier(entity, false, this.caches);
        CqnSelect cqnSelect = (CqnSelect)CQL.copy((CqnStatement)ApplicationServicePersonalDataHandler.modifySelectStatement(entity, context.getCqn()), (Modifier)modifier);
        PersonalDataAnalyzerAccess analyzer = new PersonalDataAnalyzerAccess(entity, modifier.getSensitiveElements(), this.caches, this.runtime);
        if (analyzer.hasPersonalData()) {
            context.setCqn(cqnSelect);
            context.put(PD_ANALYZER_ACCESS_KEY, (Object)analyzer);
        }
    }

    @After
    @HandlerOrder(value=-10900)
    protected void afterRead(CdsReadEventContext context) {
        PersonalDataAnalyzerAccess pdAnalyzer = (PersonalDataAnalyzerAccess)context.get(PD_ANALYZER_ACCESS_KEY);
        if (pdAnalyzer != null) {
            context.put(PD_ANALYZER_ACCESS_KEY, null);
            Result result = context.getResult();
            pdAnalyzer.setData(context.getResult().list());
            List<Access> accesses = pdAnalyzer.getDataAccesses();
            if (!accesses.isEmpty()) {
                this.auditLog.logDataAccess(accesses);
            }
            DataProcessor.create().addConverter((path, element, type) -> element.getName().startsWith("@audit:"), (path, element, value) -> CdsDataProcessor.Converter.REMOVE).process(result);
            ApplicationServicePersonalDataHandler.removeEmptyMaps((Iterable<? extends Map<String, Object>>)result);
        }
    }

    private static CqnSelect modifySelectStatement(CdsEntity entity, CqnSelect select) {
        CqnSelect newSelect = (CqnSelect)CqnStatementUtils.resolveKeyPlaceholder((CdsStructuredType)entity, (CqnStatement)select);
        newSelect = CqnStatementUtils.resolveStar((CqnSelect)newSelect, (CdsStructuredType)entity);
        return newSelect;
    }

    private static void removeEmptyMaps(Iterable<? extends Map<String, Object>> result) {
        result.forEach(row -> {
            Iterator iter = row.entrySet().iterator();
            while (iter.hasNext()) {
                List valueList;
                Map.Entry entry = iter.next();
                if (entry.getValue() instanceof Map) {
                    ApplicationServicePersonalDataHandler.removeEmptyMaps(Arrays.asList((Map)entry.getValue()));
                    if (!((Map)entry.getValue()).isEmpty()) continue;
                    iter.remove();
                    continue;
                }
                if (!(entry.getValue() instanceof List) || (valueList = (List)entry.getValue()).isEmpty() || !(valueList.get(0) instanceof Map)) continue;
                ApplicationServicePersonalDataHandler.removeEmptyMaps((List)entry.getValue());
            }
        });
    }
}

