/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.cds;

import com.sap.cds.impl.DataProcessor;
import com.sap.cds.ql.CQL;
import com.sap.cds.ql.Select;
import com.sap.cds.ql.Selectable;
import com.sap.cds.ql.cqn.CqnLock;
import com.sap.cds.ql.cqn.CqnSelect;
import com.sap.cds.ql.cqn.Path;
import com.sap.cds.ql.impl.PathImpl;
import com.sap.cds.ql.impl.SelectBuilder;
import com.sap.cds.reflect.CdsAnnotatable;
import com.sap.cds.reflect.CdsAssociationType;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.reflect.CdsType;
import com.sap.cds.services.EventContext;
import com.sap.cds.services.cds.ApplicationService;
import com.sap.cds.services.cds.CqnService;
import com.sap.cds.services.handler.EventHandler;
import com.sap.cds.services.handler.annotations.Before;
import com.sap.cds.services.handler.annotations.HandlerOrder;
import com.sap.cds.services.handler.annotations.ServiceName;
import com.sap.cds.services.impl.utils.CdsServiceUtils;
import com.sap.cds.services.impl.utils.ValidatorUtils;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.model.CdsAnnotations;
import com.sap.cds.util.CdsModelUtils;
import com.sap.cds.util.OnConditionAnalyzer;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;

@ServiceName(value={"*"}, type={ApplicationService.class})
public class TargetAssertionHandler
implements EventHandler {
    @Before(event={"CREATE", "UPDATE", "UPSERT"})
    @HandlerOrder(value=11100)
    public void run(EventContext context) {
        LinkedList<Validation> validations = new LinkedList<Validation>();
        DataProcessor.create().action((DataProcessor.Action)new Action(validations)).process(CdsServiceUtils.getEntities(context), (CdsStructuredType)context.getTarget());
        validations.removeIf(check -> this.isTargetPresent((CqnService)context.getService(), check.getTarget(), check.getKeys()));
        validations.forEach(error -> {
            if (!error.getForeignKeyValues().isEmpty()) {
                error.getForeignKeyValues().forEach(item -> ValidatorUtils.handleValidationError(context, error.getPath(), error.getSource().getElement(item), CdsErrorStatuses.TARGET_ENTITY_MISSING, new Object[0]));
            } else {
                ValidatorUtils.handleValidationError(context, error.getPath(), error.getAssociation(), CdsErrorStatuses.TARGET_ENTITY_MISSING, new Object[0]);
            }
        });
    }

    private boolean isTargetPresent(CqnService service, CdsEntity target, Map<String, Object> content) {
        Select existenceCheck = ((Select)SelectBuilder.from((String)target.getQualifiedName()).hint("ignoreLocalizedViews", (Object)true)).columns(new Selectable[]{CQL.constant((Object)1).as("ID")}).limit(1L).matching(content).lock(CqnLock.Mode.SHARED);
        return service.run((CqnSelect)existenceCheck, new Object[0]).first().isPresent();
    }

    private static class Validation {
        private final Path path;
        private final CdsElement association;
        private final Map<String, Object> keys;
        private final Set<String> foreignKeyNames;

        private Validation(Path path, CdsElement association, Map<String, Object> keys, Set<String> foreignKeyNames) {
            this.path = path;
            this.association = association;
            this.keys = keys;
            this.foreignKeyNames = foreignKeyNames;
        }

        public Set<String> getForeignKeyValues() {
            return this.foreignKeyNames;
        }

        public CdsStructuredType getSource() {
            return (CdsStructuredType)this.association.getDeclaringType();
        }

        public CdsEntity getTarget() {
            return ((CdsAssociationType)this.association.getType().as(CdsAssociationType.class)).getTarget();
        }

        public Path getPath() {
            return this.path;
        }

        public CdsElement getAssociation() {
            return this.association;
        }

        public Map<String, Object> getKeys() {
            return this.keys;
        }
    }

    private static class Action
    implements DataProcessor.Action {
        private final List<Validation> validations;
        private static final Predicate<CdsElement> isAssociationRelevant = assoc -> (Boolean)Objects.requireNonNull(CdsAnnotations.ASSERT_TARGET.getOrValue((CdsAnnotatable)assoc, (Object)false)) != false && CdsModelUtils.managedToOne((CdsType)assoc.getType()) && !CdsModelUtils.isCascading((CdsModelUtils.CascadeType)CdsModelUtils.CascadeType.INSERT, (CdsElement)assoc) && !CdsModelUtils.isCascading((CdsModelUtils.CascadeType)CdsModelUtils.CascadeType.UPDATE, (CdsElement)assoc);

        public Action(List<Validation> validations) {
            this.validations = validations;
        }

        public void entry(Path path, CdsElement element, CdsStructuredType type, Map<String, Object> sourceData) {
            type.associations().filter(isAssociationRelevant).forEach(assoc -> {
                OnConditionAnalyzer onConditionAnalyzer = new OnConditionAnalyzer(assoc, false);
                String assocName = assoc.getName();
                Map targetData = sourceData.getOrDefault(assocName, Collections.emptyMap());
                HashMap targetPKs = new HashMap();
                HashSet fkNames = new HashSet();
                Map fkMapping = onConditionAnalyzer.getFkMapping();
                fkMapping.forEach((fk, pkRef) -> {
                    Object pkValue;
                    String pk = pkRef.asRef().lastSegment();
                    Object fkValue = sourceData.get(fk);
                    if (fkValue != null) {
                        targetPKs.put(pk, fkValue);
                        fkNames.add(fk);
                    }
                    if ((pkValue = targetData.get(pk)) != null) {
                        targetPKs.put(pk, pkValue);
                    }
                });
                if (targetPKs.size() == fkMapping.size()) {
                    this.validations.add(new Validation(((PathImpl)path).append(element, type, sourceData), (CdsElement)assoc, targetPKs, fkNames));
                }
            });
        }
    }
}

