/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.runtime;

import com.sap.cds.reflect.CdsModel;
import com.sap.cds.reflect.impl.CdsModelReader;
import com.sap.cds.services.Service;
import com.sap.cds.services.authentication.AuthenticationInfo;
import com.sap.cds.services.changeset.ChangeSetContext;
import com.sap.cds.services.environment.ApplicationInfo;
import com.sap.cds.services.environment.ApplicationInfoProvider;
import com.sap.cds.services.environment.CdsEnvironment;
import com.sap.cds.services.environment.CdsProperties;
import com.sap.cds.services.environment.PropertiesProvider;
import com.sap.cds.services.environment.ServiceBinding;
import com.sap.cds.services.environment.ServiceBindingProvider;
import com.sap.cds.services.impl.ServiceCatalogImpl;
import com.sap.cds.services.impl.ServiceCatalogSPI;
import com.sap.cds.services.impl.ServiceExceptionUtilsImpl;
import com.sap.cds.services.impl.ServiceSPI;
import com.sap.cds.services.impl.environment.DefaultApplicationInfoProvider;
import com.sap.cds.services.impl.environment.DefaultServiceBindingProvider;
import com.sap.cds.services.impl.environment.SimplePropertiesProvider;
import com.sap.cds.services.impl.handlerregistry.HandlerRegistryTools;
import com.sap.cds.services.impl.messages.SimpleLocalizedMessageProvider;
import com.sap.cds.services.impl.request.ParameterInfoImpl;
import com.sap.cds.services.impl.request.UserInfoImpl;
import com.sap.cds.services.impl.runtime.ChangeSetContextRunnerImpl;
import com.sap.cds.services.impl.runtime.RequestContextRunnerImpl;
import com.sap.cds.services.impl.runtime.mockusers.MockedFeatureTogglesProvider;
import com.sap.cds.services.impl.runtime.mockusers.MockedUserInfoProvider;
import com.sap.cds.services.impl.utils.CdsModelUtils;
import com.sap.cds.services.impl.utils.CdsServiceUtils;
import com.sap.cds.services.messages.LocalizedMessageProvider;
import com.sap.cds.services.request.FeatureToggle;
import com.sap.cds.services.request.FeatureTogglesInfo;
import com.sap.cds.services.request.ParameterInfo;
import com.sap.cds.services.request.RequestContext;
import com.sap.cds.services.request.UserInfo;
import com.sap.cds.services.runtime.AuthenticationInfoProvider;
import com.sap.cds.services.runtime.CdsModelProvider;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.runtime.ChangeSetContextRunner;
import com.sap.cds.services.runtime.FeatureTogglesInfoProvider;
import com.sap.cds.services.runtime.ParameterInfoProvider;
import com.sap.cds.services.runtime.Request;
import com.sap.cds.services.runtime.RequestContextRunner;
import com.sap.cds.services.runtime.UserInfoProvider;
import java.util.Locale;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CdsRuntimeImpl
implements CdsRuntime {
    private static final Logger logger = LoggerFactory.getLogger(CdsRuntimeImpl.class);
    private static final String basePackage = "com.sap.cds.";
    private final CdsEnvironment environment;
    private final ServiceCatalogImpl serviceCatalog = new ServiceCatalogImpl();
    private CdsModel cdsModel = CdsModelUtils.loadCdsModel(null);
    private ServiceBindingProvider serviceBindingProvider = new DefaultServiceBindingProvider(this);
    private ApplicationInfoProvider applicationInfoProvider = new DefaultApplicationInfoProvider(this);
    private CdsModelProvider cdsModelProvider = new DefaultModelProvider();
    private UserInfoProvider userInfoProvider = new MockedUserInfoProvider(this);
    private AuthenticationInfoProvider authenticationInfoProvider = () -> null;
    private ParameterInfoProvider parameterInfoProvider = () -> null;
    private LocalizedMessageProvider localizedMessageProvider = new SimpleLocalizedMessageProvider();
    private FeatureTogglesInfoProvider featureToggleProvider = new MockedFeatureTogglesProvider(this);

    CdsRuntimeImpl(PropertiesProvider propertiesProvider) {
        this.environment = new CdsEnvironmentImpl(propertiesProvider);
    }

    public ServiceCatalogSPI getServiceCatalog() {
        return this.serviceCatalog;
    }

    public CdsModel getCdsModel() {
        return this.cdsModel;
    }

    public CdsModel getCdsModel(UserInfo userInfo, FeatureTogglesInfo featureTogglesInfo) {
        return this.cdsModelProvider.get(userInfo, featureTogglesInfo);
    }

    public CdsEnvironment getEnvironment() {
        return this.environment;
    }

    public ParameterInfo getProvidedParameterInfo() {
        ParameterInfo parameterInfo = this.parameterInfoProvider.get();
        return parameterInfo != null ? parameterInfo : ParameterInfo.create();
    }

    public UserInfo getProvidedUserInfo() {
        UserInfo userInfo = this.userInfoProvider.get();
        return userInfo != null ? userInfo : UserInfo.create();
    }

    public AuthenticationInfo getProvidedAuthenticationInfo() {
        return this.authenticationInfoProvider.get();
    }

    public FeatureTogglesInfo getFeatureTogglesInfo(UserInfo userInfo, ParameterInfo parameterInfo) {
        FeatureTogglesInfo featureTogglesInfo = this.featureToggleProvider.get(userInfo, parameterInfo);
        return featureTogglesInfo != null ? featureTogglesInfo : FeatureTogglesInfo.create((FeatureToggle[])new FeatureToggle[0]);
    }

    public String getLocalizedMessage(String code, Object[] args, Locale locale) {
        return this.localizedMessageProvider.get(code, args, locale);
    }

    public <T> T runInRequestContext(Request request, Function<RequestContext, T> requestHandler) {
        RequestContextRunner runInRequestContext = this.requestContext();
        if (request != null && request.getRequestUser() != null) {
            runInRequestContext.user((UserInfo)new UserInfoImpl(request.getRequestUser()));
        }
        if (request != null && request.getRequestParameters() != null) {
            runInRequestContext.parameters((ParameterInfo)new ParameterInfoImpl(request.getRequestParameters(), this));
        }
        return (T)runInRequestContext.run(requestHandler);
    }

    public RequestContextRunner requestContext() {
        return new RequestContextRunnerImpl(this);
    }

    public <T> T runInChangeSetContext(Function<ChangeSetContext, T> changeSetHandler) {
        return (T)this.changeSetContext().run(changeSetHandler);
    }

    public ChangeSetContextRunner changeSetContext() {
        return new ChangeSetContextRunnerImpl(this);
    }

    void setCdsModel(String csnPath) {
        CdsModelReader.Config config = new CdsModelReader.Config.Builder().setIncludeUIAnnotations(this.environment.getCdsProperties().getModel().isIncludeUiAnnotations()).build();
        this.cdsModel = CdsModelUtils.loadCdsModel(config, csnPath);
    }

    void setCdsModel(CdsModel model) {
        this.cdsModel = model;
    }

    void setCdsModelProvider(CdsModelProvider provider) {
        this.cdsModelProvider = provider;
    }

    CdsModelProvider getCdsModelProvider() {
        return this.cdsModelProvider;
    }

    void setServiceBindingProvider(ServiceBindingProvider serviceBindingProvider) {
        this.serviceBindingProvider = serviceBindingProvider;
    }

    ServiceBindingProvider getServiceBindingProvider() {
        return this.serviceBindingProvider;
    }

    void setApplicationInfoProvider(ApplicationInfoProvider provider) {
        this.applicationInfoProvider = provider;
    }

    ApplicationInfoProvider getApplicationInfoProvider() {
        return this.applicationInfoProvider;
    }

    void setUserInfoProvider(UserInfoProvider userInfoProvider) {
        this.userInfoProvider = userInfoProvider;
    }

    UserInfoProvider getUserInfoProvider() {
        return this.userInfoProvider;
    }

    void setAuthenticationInfoProvider(AuthenticationInfoProvider authenticationInfoProvider) {
        this.authenticationInfoProvider = authenticationInfoProvider;
    }

    AuthenticationInfoProvider getAuthenticationInfoProvider() {
        return this.authenticationInfoProvider;
    }

    void setParameterInfoProvider(ParameterInfoProvider parameterInfoProvider) {
        this.parameterInfoProvider = parameterInfoProvider;
    }

    ParameterInfoProvider getParameterInfoProvider() {
        return this.parameterInfoProvider;
    }

    FeatureTogglesInfoProvider getFeatureToggleProvider() {
        return this.featureToggleProvider;
    }

    void setFeatureToggleProvider(FeatureTogglesInfoProvider featureToggleProvider) {
        this.featureToggleProvider = featureToggleProvider;
    }

    LocalizedMessageProvider getLocalizedMessageProvider() {
        return this.localizedMessageProvider;
    }

    void setLocalizedMessageProvider(LocalizedMessageProvider localizedMessageProvider) {
        this.localizedMessageProvider = localizedMessageProvider;
        ServiceExceptionUtilsImpl.defaultLocalizedMessageProvider = localizedMessageProvider;
    }

    void registerService(Service service) {
        this.serviceCatalog.register(service);
        ServiceSPI serviceSPI = CdsServiceUtils.getServiceSPI(service);
        if (serviceSPI != null) {
            serviceSPI.setCdsRuntime(this);
        }
    }

    <T> void registerEventHandler(Class<T> handlerClass, Supplier<T> handlerFactory) {
        HandlerRegistryTools.registerClass(handlerClass, handlerFactory, this.serviceCatalog);
        if (handlerClass.getPackage().getName().startsWith(basePackage)) {
            logger.debug("Registered handler class {}", (Object)handlerClass.getName());
        } else {
            logger.info("Registered handler class {}", (Object)handlerClass.getName());
        }
    }

    private class CdsEnvironmentImpl
    implements CdsEnvironment {
        private final CdsProperties properties;
        private final PropertiesProvider propertiesProvider;

        public CdsEnvironmentImpl(PropertiesProvider propertiesProvider) {
            this.propertiesProvider = propertiesProvider == null ? new SimplePropertiesProvider() : propertiesProvider;
            this.properties = (CdsProperties)this.propertiesProvider.bindPropertyClass("cds", CdsProperties.class);
            ServiceExceptionUtilsImpl.errorsProperties = this.properties.getErrors();
        }

        public CdsProperties getCdsProperties() {
            return this.properties;
        }

        public <T> T getProperty(String key, Class<T> asClazz, T defaultValue) {
            return (T)this.propertiesProvider.getProperty(key, asClazz, defaultValue);
        }

        public Stream<ServiceBinding> getServiceBindings() {
            return CdsRuntimeImpl.this.serviceBindingProvider.get();
        }

        public ApplicationInfo getApplicationInfo() {
            return CdsRuntimeImpl.this.applicationInfoProvider.get();
        }
    }

    private class DefaultModelProvider
    implements CdsModelProvider {
        private DefaultModelProvider() {
        }

        public CdsModel get(UserInfo userInfo, FeatureTogglesInfo featureTogglesInfo) {
            return CdsRuntimeImpl.this.cdsModel;
        }
    }
}

