/**************************************************************************
 * (C) 2019-2021 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.services.impl.application;

import com.sap.cds.services.application.ApplicationLifecycleService;
import com.sap.cds.services.application.ApplicationPreparedEventContext;
import com.sap.cds.services.handler.EventHandler;
import com.sap.cds.services.handler.annotations.On;
import com.sap.cds.services.handler.annotations.ServiceName;
import com.sap.cds.services.impl.utils.BuildInfo;

@ServiceName(value = "*", type = ApplicationLifecycleService.class)
public class ApplicationLifecycleBuildInfoHandler implements EventHandler {

	@On
	private void logBuildInfo(ApplicationPreparedEventContext context) {
		BuildInfo.log();
	}

}
