/**************************************************************************
 * (C) 2019-2021 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.services.impl.authorization;

import com.sap.cds.reflect.CdsKind;
import com.sap.cds.services.EventContext;
import com.sap.cds.services.impl.EventContextDelegator;
import com.sap.cds.services.authorization.AuthorizationService;
import com.sap.cds.services.authorization.GetRestrictionEventContext;

public class GetRestrictionEventContextImpl extends EventContextDelegator implements GetRestrictionEventContext {

	public static final String EVENT_GET_RESTRICTION = "GET_RESTRICTION";

	public GetRestrictionEventContextImpl(EventContext eventContext) {
		super(eventContext);
	}
	
	@Override
	public AuthorizationService getService() {
		return (AuthorizationService)super.getService();
	}
	
	private static final String PARAM_NAME = "name";
	
	private static final String PARAM_KIND = "kind";
	
	private static final String PARAM_EVENT_NAME = "eventName";
	
	private static final String PARAM_RESULT = "result";
	
	// IN
	public void setName(String name) {
		put(PARAM_NAME, name);
	}

	public String getName() {
		return (String)get(PARAM_NAME);
	}

	public void setKind(CdsKind kind) {
		put(PARAM_KIND, kind);
	}

	public CdsKind getKind() {
		return (CdsKind)get(PARAM_KIND);
	}

	public void setEventName(String event) {
		put(PARAM_EVENT_NAME, event);
	}

	public String getEventName() {
		return (String)get(PARAM_EVENT_NAME);
	}

	// OUT
	public Object getResult() {
		return get(PARAM_RESULT);
	}

	public void setResult(Object result) {
		put(PARAM_RESULT, result);
		setCompleted();
	}
}
